/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.building.module;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.core.client.gui.MaximumStockModuleWindow;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.config.MCTweaksConfigServer;
import steve_gall.minecolonies_tweaks.core.common.inventory.BlackHoleItemHandler;
import steve_gall.minecolonies_tweaks.core.common.network.message.MaximumStockUpdateMessage;

public class MaximumStockModule
extends AbstractBuildingModule
implements IPersistentModule,
ITickingModule {
    protected final Object2IntMap<ItemStorage> maximumStock = new Object2IntOpenHashMap();

    public boolean hasReachedLimit() {
        return this.maximumStock.size() >= this.getKindsLimit();
    }

    public int getKindsLimit() {
        IBuilding building = this.building;
        double increase = 1.0 + building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MINIMUM_STOCK);
        return (int)((double)building.getBuildingLevel() * increase * (double)((Integer)MCTweaksConfigServer.INSTANCE.jobs.maximumStockKindsPerLevel.get()).intValue());
    }

    public List<Entry> getList() {
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (Object2IntMap.Entry entry : this.maximumStock.object2IntEntrySet()) {
            list.add(new Entry(((ItemStorage)entry.getKey()).getItemStack().m_41777_(), entry.getIntValue()));
        }
        return list;
    }

    public boolean contains(ItemStack stack) {
        return this.maximumStock.containsKey((Object)new ItemStorage(stack));
    }

    public void add(ItemStack stack, int quantity) {
        if (stack.m_41619_()) {
            return;
        }
        this.maximumStock.put((Object)new ItemStorage(stack.m_41777_()), quantity);
        this.markDirty();
    }

    public void remove(ItemStack stack) {
        this.maximumStock.removeInt((Object)new ItemStorage(stack));
        this.markDirty();
    }

    public void onColonyTick(@NotNull IColony colony) {
        for (Object2IntMap.Entry entry : this.maximumStock.object2IntEntrySet()) {
            ItemStack stack = ((ItemStorage)entry.getKey()).getItemStack();
            if (stack.m_41619_()) continue;
            int maxStackSize = stack.m_41741_();
            int target = entry.getIntValue() * maxStackSize;
            Predicate<ItemStack> predicate = s -> this.matchesItem((ItemStack)s, stack);
            int count = InventoryUtils.getCountFromBuilding((IBuilding)this.building, predicate);
            int over = count - target;
            if (over <= 0) continue;
            InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler((ICapabilityProvider)this.building, predicate, (int)over, (IItemHandler)BlackHoleItemHandler.INSTANCE);
        }
    }

    public boolean matchesItem(ItemStack stack1, ItemStack stack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize((ItemStack)stack1, (ItemStack)stack2, (boolean)false, (boolean)false);
    }

    public void deserializeNBT(CompoundTag compound) {
        this.maximumStock.clear();
        ListTag maximumStackTag = compound.m_128437_("maximumStock", 10);
        for (int i = 0; i < maximumStackTag.size(); ++i) {
            CompoundTag entryTag = maximumStackTag.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)entryTag.m_128469_("key"));
            if (stack.m_41619_()) continue;
            ItemStorage key = new ItemStorage(stack);
            int value = entryTag.m_128451_("value");
            this.maximumStock.put((Object)key, value);
        }
    }

    public void serializeNBT(CompoundTag compound) {
        ListTag maximumStackTag = new ListTag();
        for (Object2IntMap.Entry entry : this.maximumStock.object2IntEntrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128365_("key", (Tag)((ItemStorage)entry.getKey()).getItemStack().serializeNBT());
            entryTag.m_128405_("value", entry.getIntValue());
            maximumStackTag.add((Object)entryTag);
        }
        compound.m_128365_("maximumStock", (Tag)maximumStackTag);
    }

    public void serializeToView(FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.maximumStock.size());
        for (Object2IntMap.Entry entry : this.maximumStock.object2IntEntrySet()) {
            buf.m_130055_(((ItemStorage)entry.getKey()).getItemStack());
            buf.writeInt(entry.getIntValue());
        }
    }

    public record Entry(ItemStack stack, int quantity) {
    }

    public static class View
    extends AbstractBuildingModuleView {
        public static final Component DESC = Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.maximumstock");
        protected final Object2IntMap<ItemStorage> maximumStock = new Object2IntOpenHashMap();

        public void deserialize(@NotNull FriendlyByteBuf buf) {
            this.maximumStock.clear();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                ItemStorage key = new ItemStorage(buf.m_130267_());
                int value = buf.readInt();
                this.maximumStock.put((Object)key, value);
            }
        }

        public List<Entry> getList() {
            ArrayList<Entry> list = new ArrayList<Entry>();
            for (Object2IntMap.Entry entry : this.maximumStock.object2IntEntrySet()) {
                list.add(new Entry(((ItemStorage)entry.getKey()).getItemStack().m_41777_(), entry.getIntValue()));
            }
            return list;
        }

        public boolean hasReachedLimit() {
            return this.maximumStock.size() >= this.getKindsLimit();
        }

        public int getKindsLimit() {
            IBuildingView building = this.buildingView;
            double increase = 1.0 + building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MINIMUM_STOCK);
            return (int)((double)building.getBuildingLevel() * increase * (double)((Integer)MCTweaksConfigServer.INSTANCE.jobs.maximumStockKindsPerLevel.get()).intValue());
        }

        public boolean contains(ItemStack stack) {
            return this.maximumStock.containsKey((Object)new ItemStorage(stack));
        }

        public void add(ItemStack stack, int quantity) {
            if (stack.m_41619_()) {
                return;
            }
            this.maximumStock.put((Object)new ItemStorage(stack.m_41777_()), quantity);
            MineColoniesTweaks.network().sendToServer(MaximumStockUpdateMessage.add(this, stack, quantity));
        }

        public void remove(ItemStack stack) {
            this.maximumStock.removeInt((Object)new ItemStorage(stack));
            MineColoniesTweaks.network().sendToServer(MaximumStockUpdateMessage.remove(this, stack));
        }

        public BOWindow getWindow() {
            return new MaximumStockModuleWindow(this);
        }

        public String getIcon() {
            return "maximumstock";
        }

        public Component getDesc() {
            return DESC;
        }
    }
}

