/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.research.IResearchEffect;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Logger;
import steve_gall.minecolonies_tweaks.api.common.research.ResearchEffectChangedEventArgs;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.colony.ColonyExtension;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksTags;
import steve_gall.minecolonies_tweaks.core.common.research.GlobalResearchEffectExtension;

public class CommonForgeEventHandler {
    public static final Component GREAT_FOOD_TOOLTIP = Component.m_237115_((String)"com.minecolonies.core.item.food.tooltip.tier.3");
    public static final Component DECENT_FOOD_TOOLTIP = Component.m_237115_((String)"com.minecolonies.core.item.food.tooltip.tier.2");
    public static final Component FINE_FOOD_TOOLTIP = Component.m_237115_((String)"com.minecolonies.core.item.food.tooltip.tier.1");

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        int tier = MCTweaksTags.Items.getFoodTier(arg_0 -> ((ItemStack)e.getItemStack()).m_204117_(arg_0));
        if (tier == 3) {
            e.getToolTip().add(1, GREAT_FOOD_TOOLTIP);
        } else if (tier == 2) {
            e.getToolTip().add(1, DECENT_FOOD_TOOLTIP);
        } else if (tier == 1) {
            e.getToolTip().add(1, FINE_FOOD_TOOLTIP);
        }
    }

    @SubscribeEvent
    public void onLivingChangeTarget(LivingChangeTargetEvent e) {
        TamableAnimal animal;
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof TamableAnimal && (livingEntity = (animal = (TamableAnimal)livingEntity).m_269323_()) instanceof Player) {
            IColony colony;
            EntityCitizen citizen;
            ICitizenColonyHandler citizenColonyHandler;
            Player player = (Player)livingEntity;
            LivingEntity livingEntity2 = e.getNewTarget();
            if (livingEntity2 instanceof EntityCitizen && (citizenColonyHandler = (citizen = (EntityCitizen)livingEntity2).getCitizenColonyHandler()) != null && (colony = citizenColonyHandler.getColony()) != null && colony.getPermissions().isColonyMember(player)) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onResearchEffectChangedEvent(ResearchEffectChangedEventArgs e) {
        IResearchEffect iResearchEffect;
        if (e.getNext() > e.getPrev() && (iResearchEffect = e.getEffect()) instanceof GlobalResearchEffectExtension) {
            GlobalResearchEffectExtension extension = (GlobalResearchEffectExtension)iResearchEffect;
            String command = extension.minecolonies_tweaks$getCommand();
            if (command == null) {
                return;
            }
            IColony colony = e.getColony();
            command = this.patchCommand(e, command);
            MinecraftServer server = colony.getWorld().m_7654_();
            ServerPlayer owner = server.m_6846_().m_11259_(colony.getPermissions().getOwner());
            if (owner != null || extension.minecolonies_tweaks$isOfflineRunnable()) {
                this.performCommand(server, command);
            } else {
                ((ColonyExtension)colony).minecolonies_tweaks$getCommandQueue().add(command);
                MineColoniesTweaks.LOGGER.info("ResearchEffectCommand Enqueued: " + command);
            }
        }
    }

    private String patchCommand(ResearchEffectChangedEventArgs e, String command) {
        IColony colony = e.getColony();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("effect", e.getEffect().getId().toString());
        placeholders.put("ownerName", colony.getPermissions().getOwnerName());
        placeholders.put("ownerUUID", colony.getPermissions().getOwner().toString());
        placeholders.put("prev", String.valueOf(e.getPrev()));
        placeholders.put("next", String.valueOf(e.getNext()));
        placeholders.put("delta", String.valueOf(e.getNext() - e.getPrev()));
        for (Map.Entry entry : placeholders.entrySet()) {
            command = command.replace("<" + (String)entry.getKey() + ">", (CharSequence)entry.getValue());
        }
        return command;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = IColonyManager.getInstance().getIColonyByOwner(player2.m_9236_(), (Player)player2);
            if (player instanceof ColonyExtension) {
                ColonyExtension extension = (ColonyExtension)player;
                ArrayList<String> queue = extension.minecolonies_tweaks$getCommandQueue();
                MinecraftServer server = player2.m_9236_().m_7654_();
                for (String command : queue) {
                    this.performCommand(server, command);
                }
                queue.clear();
            }
        }
    }

    private boolean performCommand(MinecraftServer server, String command) {
        Logger logger = MineColoniesTweaks.LOGGER;
        try {
            server.m_129892_().m_82094_().execute(command, (Object)server.m_129893_());
            logger.info("ResearchEffectCommand Performed: " + command);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            logger.error("ResearchEffectCommand Error");
            logger.error("Commandline: " + command);
            return false;
        }
    }
}

