/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.datalistener.StudyItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.core.common.building.module.StudyItemListModule;

public class StudyItemListModuleWindow
extends AbstractModuleWindow<StudyItemListModule.View> {
    public static final String OUTPUT_ICON = "outputIcon";
    public static final String OUTPUT_NAME = "outputName";
    public static final Component ON = Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon");
    public static final Component OFF = Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff");
    protected final StudyItemListModule.View module;
    protected final ScrollingList resourceList;
    private final List<ItemCache> groupedItemList;
    private final Map<ItemStack, String> descriptionCache;
    private final Map<ItemStack, String> hoverNameCache;
    private String filter = "";
    private int tick = 0;
    private List<ItemCache> currentDisplayedList;

    public StudyItemListModuleWindow(StudyItemListModule.View module, ResourceLocation res) {
        super((IBuildingModuleView)module, res);
        this.module = module;
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class);
        this.groupedItemList = new ArrayList<ItemCache>(StudyItemListener.getAllStudyItems().entrySet().stream().map(x$0 -> new ItemCache((Map.Entry<ResourceLocation, StudyItemListener.StudyItem>)x$0)).toList());
        this.descriptionCache = new HashMap<ItemStack, String>();
        this.hoverNameCache = new HashMap<ItemStack, String>();
        ((TextField)this.window.findPaneOfTypeByID("input", TextField.class)).setHandler(input -> this.setFilter(input.getText()));
    }

    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        String buttonId = button.getID();
        if (Objects.equals(buttonId, "switch")) {
            int row = this.resourceList.getListElementIndexByPane((Pane)button);
            ItemCache item = this.currentDisplayedList.get(row);
            this.toggleItems(Arrays.asList(item));
        } else if (Objects.equals(buttonId, "resetDefault")) {
            this.clearItems();
        } else if (Objects.equals(buttonId, "toggleInCurrent")) {
            this.toggleItems(this.currentDisplayedList);
        } else if (Objects.equals(buttonId, "resetInCurrent")) {
            this.removeItems(this.currentDisplayedList);
        }
    }

    public void addItems(Collection<ItemCache> items) {
        this.module.addIds(items.stream().map(item -> item.id).toList());
        this.resourceList.refreshElementPanes();
    }

    public void removeItems(Collection<ItemCache> items) {
        this.module.removeIds(items.stream().map(item -> item.id).toList());
        this.resourceList.refreshElementPanes();
    }

    public void toggleItems(Collection<ItemCache> items) {
        List<ResourceLocation> toRemoves = items.stream().map(item -> item.id).filter(id -> this.module.containsId((ResourceLocation)id)).toList();
        List<ResourceLocation> toAddes = items.stream().map(item -> item.id).filter(id -> !this.module.containsId((ResourceLocation)id)).toList();
        this.module.removeIds(toRemoves);
        this.module.addIds(toAddes);
        this.resourceList.refreshElementPanes();
    }

    public void clearItems() {
        this.module.clearIds();
        this.resourceList.refreshElementPanes();
    }

    public void setFilter(String newFilter) {
        if (!newFilter.equals(this.filter)) {
            this.filter = newFilter;
            this.tick = 10;
        }
    }

    public void onOpened() {
        super.onOpened();
        this.updateResources();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }

    private boolean testFilter(ItemStack stack, String lowerCaseFilter) {
        return this.descriptionCache.computeIfAbsent(stack, s -> s.m_41778_().toLowerCase(Locale.US)).contains(lowerCaseFilter) || this.hoverNameCache.computeIfAbsent(stack, s -> s.m_41786_().getString().toLowerCase(Locale.US)).contains(lowerCaseFilter);
    }

    private boolean testFilter(ItemCache item, String lowerCaseFilter) {
        return this.testFilter(item.icon, lowerCaseFilter);
    }

    protected void updateResources() {
        Predicate<ItemCache> filterPredicate;
        String lowerCase = this.filter.toLowerCase(Locale.US);
        Predicate<ItemCache> predicate = filterPredicate = this.filter.isEmpty() ? item -> true : item -> this.testFilter((ItemCache)item, lowerCase);
        if (this.currentDisplayedList != null) {
            this.currentDisplayedList.clear();
            this.updateResourceList();
        }
        this.currentDisplayedList = new ArrayList<ItemCache>();
        this.groupedItemList.stream().filter(filterPredicate).forEach(this.currentDisplayedList::add);
        this.currentDisplayedList.sort(this::compareResources);
        this.updateResourceList();
    }

    protected int compareResources(ItemCache item1, ItemCache item2) {
        boolean isInverted = this.module.isInverted();
        boolean contains1 = this.module.containsId(item1.id);
        boolean contains2 = this.module.containsId(item2.id);
        if (isInverted) {
            return Boolean.compare(contains1, contains2);
        }
        return Boolean.compare(contains2, contains1);
    }

    private void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return StudyItemListModuleWindow.this.currentDisplayedList.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ItemCache item = StudyItemListModuleWindow.this.currentDisplayedList.get(index);
                ItemIcon outputIcon = (ItemIcon)rowPane.findPaneOfTypeByID(StudyItemListModuleWindow.OUTPUT_ICON, ItemIcon.class);
                outputIcon.setItem(item.icon);
                Text outputLabel = (Text)rowPane.findPaneOfTypeByID(StudyItemListModuleWindow.OUTPUT_NAME, Text.class);
                outputLabel.setText(item.icon.m_41786_());
                outputLabel.setColors(0);
                Text breakChanceLabel = (Text)rowPane.findPaneOfTypeByID("breakChance", Text.class);
                breakChanceLabel.setText(item.tooltip.get(0));
                breakChanceLabel.setColors(0);
                boolean contains = StudyItemListModuleWindow.this.module.containsId(item.id);
                boolean isInverted = StudyItemListModuleWindow.this.module.isInverted();
                Button switchButton = (Button)rowPane.findPaneOfTypeByID("switch", Button.class);
                boolean on = isInverted && !contains || !isInverted && contains;
                switchButton.setText(on ? ON : OFF);
            }
        });
    }

    public class ItemCache {
        public final ResourceLocation id;
        public final StudyItemListener.StudyItem item;
        public final ItemStack icon;
        public final List<MutableComponent> tooltip;

        public ItemCache(Map.Entry<ResourceLocation, StudyItemListener.StudyItem> entry) {
            this.id = entry.getKey();
            this.item = entry.getValue();
            this.icon = new ItemStack((ItemLike)this.item.item());
            this.tooltip = Arrays.asList(Component.m_237110_((String)"minecolonies_tweaks.gui.break_chance", (Object[])new Object[]{this.item.breakChance()}));
        }
    }
}

