/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.registries;

import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.crafting.registry.RecipeTypeEntry;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class DeferredRegisterHelper {
    public static DeferredRegister<BuildingEntry> buildings(String modid) {
        return DeferredRegister.create((ResourceLocation)new ResourceLocation("minecolonies", "buildings"), (String)modid);
    }

    public static RegistryObject<BuildingEntry> registerBuilding(DeferredRegister<BuildingEntry> register, String name, Consumer<BuildingEntry.Builder> consumer) {
        ResourceLocation rl = register.createTagKey(name).f_203868_();
        return register.register(name, () -> {
            BuildingEntry.Builder builder = new BuildingEntry.Builder();
            builder.setRegistryName(rl);
            consumer.accept(builder);
            return builder.createBuildingEntry();
        });
    }

    public static DeferredRegister<GuardType> guardTypes(String modid) {
        return DeferredRegister.create((ResourceLocation)new ResourceLocation("minecolonies", "guardtypes"), (String)modid);
    }

    public static RegistryObject<GuardType> registerGuardType(DeferredRegister<GuardType> register, RegistryObject<JobEntry> jobEntry, Consumer<GuardType.Builder> consumer) {
        return DeferredRegisterHelper.registerGuardType(register, jobEntry.getId().m_135815_(), jobEntry, consumer);
    }

    public static RegistryObject<GuardType> registerGuardType(DeferredRegister<GuardType> register, String name, Supplier<JobEntry> jobEntry, Consumer<GuardType.Builder> consumer) {
        ResourceLocation rl = register.createTagKey(name).f_203868_();
        return register.register(name, () -> {
            GuardType.Builder builder = new GuardType.Builder();
            builder.setJobTranslationKey(rl.m_135827_() + ".job." + name);
            builder.setButtonTranslationKey(rl.m_135827_() + ".gui.workerhuts." + name);
            builder.setJobEntry(jobEntry);
            builder.setRegistryName(rl);
            consumer.accept(builder);
            return builder.createGuardType();
        });
    }

    public static DeferredRegister<JobEntry> jobs(String modid) {
        return DeferredRegister.create((ResourceLocation)new ResourceLocation("minecolonies", "jobs"), (String)modid);
    }

    public static RegistryObject<JobEntry> registerJobEntry(DeferredRegister<JobEntry> register, String name, Consumer<JobEntry.Builder> consumer) {
        ResourceLocation rl = register.createTagKey(name).f_203868_();
        return register.register(name, () -> {
            JobEntry.Builder builder = new JobEntry.Builder();
            builder.setRegistryName(rl);
            consumer.accept(builder);
            return builder.createJobEntry();
        });
    }

    public static Map<EventType, List<Tuple<SoundEvent, SoundEvent>>> registerJobSoundEvents(DeferredRegister<SoundEvent> register, String name) {
        String namespace = register.createTagKey(name).f_203868_().m_135827_();
        HashMap<EventType, List<Tuple<SoundEvent, SoundEvent>>> map = new HashMap<EventType, List<Tuple<SoundEvent, SoundEvent>>>();
        for (EventType event : EventType.values()) {
            ArrayList<Tuple> individualSounds = new ArrayList<Tuple>();
            for (int i = 1; i <= 4; ++i) {
                String prefix = "citizen." + name;
                String suffix = i + "." + event.getId();
                SoundEvent maleSoundEvent = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(namespace, prefix + ".male" + suffix));
                SoundEvent femaleSoundEvent = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(namespace, prefix + ".female" + suffix));
                register.register(maleSoundEvent.m_11660_().m_135815_(), () -> maleSoundEvent);
                register.register(femaleSoundEvent.m_11660_().m_135815_(), () -> femaleSoundEvent);
                individualSounds.add(new Tuple((Object)maleSoundEvent, (Object)femaleSoundEvent));
            }
            map.put(event, individualSounds);
        }
        return map;
    }

    public static DeferredRegister<CraftingType> craftingTypes(String modid) {
        return DeferredRegister.create((ResourceLocation)new ResourceLocation("minecolonies", "craftingtypes"), (String)modid);
    }

    public static <T extends CraftingType> RegistryObject<T> registerCraftingType(DeferredRegister<CraftingType> register, String name, Function<ResourceLocation, T> func) {
        ResourceLocation id = register.createTagKey(name).f_203868_();
        return register.register(name, () -> (CraftingType)func.apply(id));
    }

    public static DeferredRegister<RecipeTypeEntry> recipeTypeEntries(String modid) {
        return DeferredRegister.create((ResourceLocation)new ResourceLocation("minecolonies", "recipetypeentries"), (String)modid);
    }

    public static RegistryObject<RecipeTypeEntry> registerRecipeTypeEntry(DeferredRegister<RecipeTypeEntry> register, String name, BiConsumer<ResourceLocation, RecipeTypeEntry.Builder> consumer) {
        ResourceLocation id = register.createTagKey(name).f_203868_();
        return register.register(name, () -> {
            RecipeTypeEntry.Builder builder = new RecipeTypeEntry.Builder();
            builder.setRegistryName(id);
            consumer.accept(id, builder);
            return builder.createRecipeTypeEntry();
        });
    }

    public static DeferredRegister<EquipmentTypeEntry> equipmentTypes(String modid) {
        return DeferredRegister.create((ResourceLocation)new ResourceLocation("minecolonies", "equipmenttypes"), (String)modid);
    }

    private DeferredRegisterHelper() {
    }
}

