/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.requestsystem;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.CustomizableObjectRegistry;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.DeliverableObjectRegistry;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.ICustomizableRequestable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class CustomizableDeliverable
implements ICustomizableRequestable,
IDeliverable {
    public static final TypeToken<CustomizableDeliverable> TYPE_TOKEN = TypeToken.of(CustomizableDeliverable.class);
    public static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TYPE_TOKEN).stream().filter(type -> !type.equals((Object)TypeConstants.OBJECT)).collect(Collectors.toSet());
    public static final String TAG_ID = "ID";
    public static final String TAG_OBJECT = "Object";
    public static final String TAG_RESULT = "Result";
    @NotNull
    private final ResourceLocation id;
    @Nullable
    private final IDeliverableObject object;
    @NotNull
    private ItemStack result;

    public CustomizableDeliverable(@Nullable IDeliverableObject object) {
        this.id = object != null ? object.getId() : CustomizableObjectRegistry.EMPTY_ID;
        this.object = object;
        this.result = ItemStack.f_41583_;
    }

    public CustomizableDeliverable(@NotNull ResourceLocation id, @Nullable IDeliverableObject object, @NotNull ItemStack result) {
        this.id = id;
        this.object = object;
        this.result = result;
    }

    @NotNull
    public static CompoundTag serialize(@NotNull IFactoryController controller, @NotNull CustomizableDeliverable input) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(TAG_ID, input.getId().toString());
        compound.m_128365_(TAG_OBJECT, (Tag)DeliverableObjectRegistry.INSTANCE.serializeWithoutId(controller, input.getObject()));
        compound.m_128365_(TAG_RESULT, (Tag)input.getResult().serializeNBT());
        return compound;
    }

    @NotNull
    public static CustomizableDeliverable deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag compound) {
        ResourceLocation id = new ResourceLocation(compound.m_128461_(TAG_ID));
        IDeliverableObject object = (IDeliverableObject)DeliverableObjectRegistry.INSTANCE.deserializeWithoutId(controller, compound.m_128469_(TAG_OBJECT), id);
        ItemStack result = ItemStack.m_41712_((CompoundTag)compound.m_128469_(TAG_RESULT));
        return new CustomizableDeliverable(id, object, result);
    }

    public static void serialize(@NotNull IFactoryController controller, @NotNull FriendlyByteBuf buffer, @NotNull CustomizableDeliverable input) {
        buffer.m_130085_(input.getId());
        buffer.m_130079_(DeliverableObjectRegistry.INSTANCE.serializeWithoutId(controller, input.getObject()));
        buffer.m_130055_(input.getResult());
    }

    @NotNull
    public static CustomizableDeliverable deserialize(@NotNull IFactoryController controller, @NotNull FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        IDeliverableObject object = (IDeliverableObject)DeliverableObjectRegistry.INSTANCE.deserializeWithoutId(controller, buffer.m_130260_(), id);
        ItemStack result = buffer.m_130267_();
        return new CustomizableDeliverable(id, object, result);
    }

    public boolean matches(@NotNull ItemStack stack) {
        IDeliverableObject object = this.getObject();
        return object != null && object.matches(stack);
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @Nullable
    public IDeliverableObject getObject() {
        return this.object;
    }

    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @NotNull
    public CustomizableDeliverable copyWithCount(int newCount) {
        IDeliverableObject object = this.getObject();
        return new CustomizableDeliverable(this.id, object != null ? object.copyWithCount(newCount) : null, this.result);
    }

    public int getCount() {
        IDeliverableObject object = this.getObject();
        return object != null ? object.getCount() : 0;
    }

    public int getMinimumCount() {
        IDeliverableObject object = this.getObject();
        return object != null ? object.getMinimumCount() : 0;
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CustomizableDeliverable) {
            CustomizableDeliverable other = (CustomizableDeliverable)o;
            return Objects.equals(this.getObject(), other.getObject()) && ItemStackUtils.compareItemStacksIgnoreStackSize((ItemStack)this.getResult(), (ItemStack)other.getResult()) != false;
        }
        return false;
    }

    public int hashCode() {
        IDeliverableObject object = this.getObject();
        return (object != null ? object.hashCode() : 0) * 31 + this.getResult().hashCode();
    }

    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

