/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.network;

import com.mrcrayfish.framework.api.network.FrameworkNetwork;
import com.mrcrayfish.framework.api.network.MessageDirection;
import com.mrcrayfish.framework.api.network.message.HandshakeMessage;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public interface FrameworkNetworkBuilder {
    public <T extends PlayMessage<T>> FrameworkNetworkBuilder registerPlayMessage(Class<T> var1);

    public <T extends PlayMessage<T>> FrameworkNetworkBuilder registerPlayMessage(Class<T> var1, @Nullable MessageDirection var2);

    public <T extends HandshakeMessage<T>> FrameworkNetworkBuilder registerHandshakeMessage(Class<T> var1, boolean var2);

    public <T extends HandshakeMessage<T>> FrameworkNetworkBuilder registerHandshakeMessage(Class<T> var1, @Nullable Function<Boolean, List<Pair<String, T>>> var2);

    public FrameworkNetworkBuilder ignoreClient();

    public FrameworkNetworkBuilder ignoreServer();

    public FrameworkNetwork build();

    public static <T extends HandshakeMessage<T>> Function<Boolean, List<Pair<String, T>>> createHandshakeMessageSupplier(Class<T> messageClass) {
        return isLocal -> {
            try {
                return Collections.singletonList(Pair.of((Object)messageClass.getName(), (Object)((HandshakeMessage)messageClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Inaccessible no-arg constructor for message " + messageClass.getName(), e);
            }
        };
    }
}

