/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.model;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.CamouflageableBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public abstract class CamouflagingModel
implements IDynamicBakedModel {
    private final BakedModel baseModel;

    CamouflagingModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        if (state == null || !(state.m_60734_() instanceof CamouflageableBlock)) {
            return this.baseModel.getQuads(state, side, rand, modelData, renderType);
        }
        BlockState camoState = (BlockState)modelData.get(CamouflageableBlock.CAMOUFLAGE_STATE);
        if (renderType == null) {
            renderType = RenderType.m_110451_();
        }
        if (camoState == null && renderType == RenderType.m_110451_()) {
            return this.baseModel.getQuads(state, side, rand, modelData, renderType);
        }
        if (camoState != null && this.getRenderTypes(camoState, rand, modelData).contains(renderType)) {
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(camoState);
            return model.getQuads(camoState, side, rand, modelData, renderType);
        }
        return Collections.emptyList();
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        BlockState camoState = (BlockState)data.get(CamouflageableBlock.CAMOUFLAGE_STATE);
        return super.getRenderTypes(camoState == null ? state : camoState, rand, data);
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }

    public boolean m_7547_() {
        return false;
    }

    static class TemplateFrameModel
    extends CamouflagingModel {
        TemplateFrameModel(BakedModel baseModel) {
            super(baseModel);
        }
    }

    static class RouterModel
    extends CamouflagingModel {
        RouterModel(BakedModel baseModel) {
            super(baseModel);
        }
    }
}

