/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.LocationPredicateAccessor;
import fzzyhmstrs.emi_loot.parser.BlockPredicateParser;
import fzzyhmstrs.emi_loot.parser.FluidPredicateParser;
import fzzyhmstrs.emi_loot.parser.LightPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.util.LText;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public class LocationPredicateParser {
    public static Component parseLocationPredicate(LocationPredicate predicate) {
        MinMaxBounds.Doubles x = ((LocationPredicateAccessor)predicate).getX();
        if (!x.equals(MinMaxBounds.Doubles.f_154779_)) {
            return LText.translatable("emi_loot.location_predicate.x", x.m_55305_(), x.m_55326_());
        }
        MinMaxBounds.Doubles y = ((LocationPredicateAccessor)predicate).getY();
        if (!y.equals(MinMaxBounds.Doubles.f_154779_)) {
            return LText.translatable("emi_loot.location_predicate.y", y.m_55305_(), y.m_55326_());
        }
        MinMaxBounds.Doubles z = ((LocationPredicateAccessor)predicate).getZ();
        if (!z.equals(MinMaxBounds.Doubles.f_154779_)) {
            return LText.translatable("emi_loot.location_predicate.z", z.m_55305_(), z.m_55326_());
        }
        ResourceKey<Level> dim = ((LocationPredicateAccessor)predicate).getDimension();
        if (dim != null) {
            return LText.translatable("emi_loot.location_predicate.dim", dim.m_135782_().toString());
        }
        ResourceKey<Biome> biome = ((LocationPredicateAccessor)predicate).getBiome();
        if (biome != null) {
            return LText.translatable("emi_loot.location_predicate.biome", biome.m_135782_().toString());
        }
        ResourceKey<Structure> feature = ((LocationPredicateAccessor)predicate).getFeature();
        if (feature != null) {
            return LText.translatable("emi_loot.location_predicate.structure", feature.m_135782_().toString());
        }
        Boolean smokey = ((LocationPredicateAccessor)predicate).getSmokey();
        if (smokey != null) {
            if (smokey.booleanValue()) {
                return LText.translatable("emi_loot.location_predicate.smoke_true");
            }
            return LText.translatable("emi_loot.location_predicate.smoke_false");
        }
        LightPredicate light = ((LocationPredicateAccessor)predicate).getLight();
        if (!light.equals(LightPredicate.f_51335_)) {
            return LightPredicateParser.parseLightPredicate(light);
        }
        BlockPredicate block = ((LocationPredicateAccessor)predicate).getBlock();
        if (!block.equals(BlockPredicate.f_17902_)) {
            return BlockPredicateParser.parseBlockPredicate(block);
        }
        FluidPredicate fluid = ((LocationPredicateAccessor)predicate).getFluid();
        if (!fluid.equals(FluidPredicate.f_41094_)) {
            return FluidPredicateParser.parseFluidPredicate(fluid);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty or unparsable location predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

