/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.util;

import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.block.BoatFrame;
import com.alekiponi.alekiships.common.block.FlatBoatFrameBlock;
import com.alekiponi.alekiships.common.entity.AlekiShipsEntities;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.util.BoatMaterial;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public enum VanillaWood implements BoatMaterial
{
    OAK(Blocks.f_50705_, Items.f_42038_, Items.f_41845_),
    SPRUCE(Blocks.f_50741_, Items.f_42039_, Items.f_41846_),
    BIRCH(Blocks.f_50742_, Items.f_42040_, Items.f_41847_),
    ACACIA(Blocks.f_50744_, Items.f_42042_, Items.f_41849_),
    CHERRY(Blocks.f_271304_, Items.f_271316_, Items.f_271164_),
    JUNGLE(Blocks.f_50743_, Items.f_42041_, Items.f_41848_),
    DARK_OAK(Blocks.f_50745_, Items.f_42043_, Items.f_41850_),
    CRIMSON(Blocks.f_50655_, Items.f_42044_, Items.f_41851_),
    WARPED(Blocks.f_50656_, Items.f_42045_, Items.f_41879_),
    MANGROVE(Blocks.f_220865_, Items.f_220188_, Items.f_220182_),
    BAMBOO(Blocks.f_244477_, Items.f_244106_, Items.f_256923_);

    private final Block plankBlock;
    private final Item railingItem;
    private final Item strippedLogItem;

    private VanillaWood(Block plankBlock, Item railingItem, Item strippedLogItem) {
        this.plankBlock = plankBlock;
        this.railingItem = railingItem;
        this.strippedLogItem = strippedLogItem;
    }

    public static void registerFrames() {
        for (VanillaWood wood : VanillaWood.values()) {
            ((FlatBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_FLAT.get())).registerFrame(wood.plankBlock.m_5456_(), (BoatFrame)AlekiShipsBlocks.WOODEN_BOAT_FRAME_FLAT.get(wood).get());
            ((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).registerFrame(wood.plankBlock.m_5456_(), (BoatFrame)AlekiShipsBlocks.WOODEN_BOAT_FRAME_ANGLED.get(wood).get());
        }
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public Item getDeckItem() {
        return this.plankBlock.m_5456_();
    }

    @Override
    public Item getRailing() {
        return this.railingItem;
    }

    @Override
    public Item getStrippedLog() {
        return this.strippedLogItem;
    }

    @Override
    public boolean withstandsLava() {
        return this.equals(WARPED) || this.equals(CRIMSON);
    }

    @Override
    public BlockState getDeckBlock() {
        return this.plankBlock.m_49966_();
    }

    @Override
    public Optional<EntityType<? extends AbstractVehicle>> getEntityType(BoatMaterial.BoatType boatType) {
        return switch (boatType) {
            default -> throw new IncompatibleClassChangeError();
            case BoatMaterial.BoatType.ROWBOAT -> Optional.of((EntityType)AlekiShipsEntities.ROWBOATS.get(this).get());
            case BoatMaterial.BoatType.SLOOP -> Optional.of((EntityType)AlekiShipsEntities.SLOOPS.get(this).get());
            case BoatMaterial.BoatType.CONSTRUCTION_SLOOP -> Optional.of((EntityType)AlekiShipsEntities.SLOOPS_UNDER_CONSTRUCTION.get(this).get());
        };
    }
}

