/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.util;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.NotNull;

public class CommonHelper {
    @Nullable
    public static Entity getAnyEntityAtCrosshair(Entity entity, double range) {
        AABB aabb;
        Vec3 from = entity.m_20299_(1.0f);
        Vec3 view = entity.m_20252_(1.0f);
        Vec3 to = from.m_82520_(view.f_82479_ * range, view.f_82480_ * range, view.f_82481_ * range);
        EntityHitResult hit = ProjectileUtil.m_37287_((Entity)entity, (Vec3)from, (Vec3)to, (AABB)(aabb = entity.m_20191_().m_82369_(view.m_82490_(range)).m_82377_(1.0, 1.0, 1.0)), e -> !e.m_5833_() && e.m_6087_(), (double)(range * range));
        return hit != null && from.m_82554_(hit.m_82450_()) < range ? hit.m_82443_() : null;
    }

    public static double vec2ToWrappedDegrees(double x, double y) {
        double direction = 0.0;
        if (y != 0.0 && x != 0.0) {
            direction = Math.round(Math.toDegrees(Math.atan(y / x)));
            if (x <= 0.0 && y <= 0.0) {
                direction += 90.0;
            } else if (x >= 0.0 && y >= 0.0) {
                direction -= 90.0;
            } else if (x <= 0.0 && y >= 0.0) {
                direction += 90.0;
            } else if (x >= 0.0 && y <= 0.0) {
                direction -= 90.0;
            }
        }
        return Mth.m_14175_((double)direction);
    }

    public static float sailForceMultiplierTable(float sailForceAngle) {
        sailForceAngle = Math.abs(Mth.m_14177_((float)sailForceAngle));
        float multiplier = 0.0f;
        if (sailForceAngle < 15.0f) {
            multiplier = 0.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 20.0f) {
            multiplier = 8.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 25.0f) {
            multiplier = 15.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 30.0f) {
            multiplier = 20.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 45.0f) {
            multiplier = 23.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 60.0f) {
            multiplier = 27.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 75.0f) {
            multiplier = 32.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 90.0f) {
            multiplier = 35.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 105.0f) {
            multiplier = 32.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 120.0f) {
            multiplier = 30.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 135.0f) {
            multiplier = 27.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 150.0f) {
            multiplier = 20.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 165.0f) {
            multiplier = 10.0f;
            return multiplier / 35.0f;
        }
        if (sailForceAngle < 180.0f) {
            multiplier = 0.0f;
            return multiplier / 35.0f;
        }
        return multiplier / 35.0f;
    }

    public static boolean everyNthTickUnique(int id, int tickCount, int n) {
        return (id + tickCount) % n == 0;
    }

    public static void giveItemToPlayer(Player player, @NotNull ItemStack stack) {
        CommonHelper.giveItemToPlayer(player, stack, -1);
    }

    public static void giveItemToPlayer(Player player, @NotNull ItemStack stack, int preferredSlot) {
        if (!stack.m_41619_()) {
            PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.m_150109_());
            Level level = player.m_9236_();
            ItemStack remainder = stack;
            if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
                remainder = inventory.insertItem(preferredSlot, stack, false);
            }
            if (!remainder.m_41619_()) {
                remainder = CommonHelper.insertItemStacked((IItemHandler)inventory, remainder, false);
            }
            if (remainder.m_41619_() || remainder.m_41613_() != stack.m_41613_()) {
                level.m_6263_((Player)null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            }
            if (!remainder.m_41619_() && !level.f_46443_) {
                ItemEntity entityitem = new ItemEntity(level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), remainder);
                entityitem.m_32010_(40);
                entityitem.m_20256_(entityitem.m_20184_().m_82542_(0.0, 1.0, 0.0));
                level.m_7967_((Entity)entityitem);
            }
        }
    }

    @NotNull
    public static ItemStack insertItemStacked(IItemHandler inventory, @NotNull ItemStack stack, boolean simulate) {
        if (inventory != null && !stack.m_41619_()) {
            ItemStack slot;
            int i;
            if (!stack.m_41753_()) {
                return CommonHelper.insertItem(inventory, stack, simulate);
            }
            int sizeInventory = inventory.getSlots();
            for (i = 0; !(i >= sizeInventory || CommonHelper.canItemStacksStackRelaxed(slot = inventory.getStackInSlot(i), stack) && (stack = inventory.insertItem(i, stack, simulate)).m_41619_()); ++i) {
            }
            if (!stack.m_41619_()) {
                for (i = 0; !(i >= sizeInventory || inventory.getStackInSlot(i).m_41619_() && (stack = inventory.insertItem(i, stack, simulate)).m_41619_()); ++i) {
                }
            }
            return stack;
        }
        return stack;
    }

    @NotNull
    public static ItemStack insertItem(IItemHandler dest, @NotNull ItemStack stack, boolean simulate) {
        if (dest != null && !stack.m_41619_()) {
            for (int i = 0; i < dest.getSlots(); ++i) {
                if (!(stack = dest.insertItem(i, stack, simulate)).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
            return stack;
        }
        return stack;
    }

    public static boolean canItemStacksStackRelaxed(@NotNull ItemStack a, @NotNull ItemStack b) {
        if (!a.m_41619_() && !b.m_41619_() && a.m_41720_() == b.m_41720_()) {
            if (!a.m_41753_()) {
                return false;
            }
            if (a.m_41782_() != b.m_41782_()) {
                return false;
            }
            return (!a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_())) && a.areCapsCompatible((CapabilityProvider)b);
        }
        return false;
    }

    public static <E extends Enum<E>, V> EnumMap<E, V> mapOfKeys(Class<E> enumClass, Function<E, V> valueMapper) {
        return CommonHelper.mapOfKeys(enumClass, key -> true, valueMapper);
    }

    public static <E extends Enum<E>, V> EnumMap<E, V> mapOfKeys(Class<E> enumClass, Predicate<E> keyPredicate, Function<E, V> valueMapper) {
        return Arrays.stream((Enum[])enumClass.getEnumConstants()).filter(keyPredicate).collect(Collectors.toMap(Function.identity(), valueMapper, (v, v2) -> v, () -> new EnumMap(enumClass)));
    }

    @Nullable
    public static Entity getEntity(@Nullable HitResult hitResult) {
        if (hitResult == null) {
            return null;
        }
        if (hitResult.m_6662_() != HitResult.Type.ENTITY) {
            return null;
        }
        return ((EntityHitResult)hitResult).m_82443_();
    }

    public static void dropContents(Level pLevel, double pX, double pY, double pZ, Container pInventory) {
        for (int i = 0; i < pInventory.m_6643_(); ++i) {
            Containers.m_18992_((Level)pLevel, (double)pX, (double)pY, (double)pZ, (ItemStack)pInventory.m_8020_(i));
        }
    }

    public static double maxHeightOfCollidableEntities(Entity entity) {
        return CommonHelper.maxHeightOfCollidableEntities(entity, entity.m_9236_(), entity.m_20191_(), entity.m_20186_());
    }

    public static double maxHeightOfCollidableEntities(@Nullable Entity entity, Level level, AABB boundingBox, double yPos) {
        for (Entity collidableEntity : level.m_6249_(entity, boundingBox, Entity::m_5829_)) {
            double maxY = collidableEntity.m_20191_().f_82292_;
            if (!(maxY > yPos)) continue;
            yPos = maxY;
        }
        return yPos;
    }

    public static ContainerLevelAccess createEntityContainerLevelAccess(final Entity entity) {
        return new ContainerLevelAccess(){

            public <T> Optional<T> m_6721_(BiFunction<Level, BlockPos, T> function) {
                return Optional.of(function.apply(entity.m_9236_(), entity.m_20183_()));
            }
        };
    }

    public static boolean stillValidEntity(Entity entity, Player player) {
        return CommonHelper.stillValidEntity(entity, player, 8);
    }

    public static boolean stillValidEntity(Entity entity, Player player, int maxDistance) {
        return !entity.m_213877_() && entity.m_20182_().m_82509_((Position)player.m_20182_(), (double)maxDistance);
    }

    public static void playHitSound(SimpleSoundPlayer simpleSoundPlayer, SoundType soundType) {
        simpleSoundPlayer.playSound(soundType.m_56778_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 8.0f, soundType.m_56774_() * 0.5f);
    }

    public static void playBreakSound(SimpleSoundPlayer simpleSoundPlayer, SoundType soundType) {
        simpleSoundPlayer.playSound(soundType.m_56775_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    public static void playPlaceSound(SimpleSoundPlayer simpleSoundPlayer, SoundType soundType) {
        simpleSoundPlayer.playSound(soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    @FunctionalInterface
    public static interface SimpleSoundPlayer {
        public void playSound(SoundEvent var1, SoundSource var2, float var3, float var4);
    }
}

