/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.network;

import com.alekiponi.alekiships.common.entity.vehiclehelper.AbstractSwitchEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSwitchEntityPacket {
    private final boolean switched;
    private final int entityID;

    public ServerboundSwitchEntityPacket(boolean switched, int entityID) {
        this.switched = switched;
        this.entityID = entityID;
    }

    public ServerboundSwitchEntityPacket(FriendlyByteBuf buffer) {
        this.switched = buffer.readBoolean();
        this.entityID = buffer.readInt();
    }

    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.switched);
        buffer.writeInt(this.entityID);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = ((NetworkEvent.Context)context.get()).getSender().m_9236_().m_6815_(this.entityID);
            ServerPlayer serverPlayer = ((NetworkEvent.Context)context.get()).getSender();
            if (entity instanceof AbstractSwitchEntity) {
                assert (serverPlayer != null);
                if (entity.m_20270_((Entity)serverPlayer) < 10.0f) {
                    ((AbstractSwitchEntity)entity).setSwitched(this.switched);
                }
            }
        });
    }
}

