/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.data;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public final class DataGenHelper {
    private DataGenHelper() {
    }

    public static String langify(String serializedName) {
        return Arrays.stream(serializedName.split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" "));
    }

    public static <T extends Comparable<T> & StringRepresentable, C extends ConditionUserBuilder<? extends C>> C matchProperty(C conditionBuilder, Block block, Property<T> property, T propertyValue) {
        conditionBuilder.m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(property, propertyValue)));
        return conditionBuilder;
    }

    public static <C extends ConditionUserBuilder<? extends C>> C matchProperty(C conditionBuilder, Block block, Property<Integer> property, int propertyValue) {
        conditionBuilder.m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_(property, propertyValue)));
        return conditionBuilder;
    }

    public static <F extends FunctionUserBuilder<? extends F>> F setCount(F functionBuilder, int count) {
        functionBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count)));
        return functionBuilder;
    }

    public static <F extends FunctionUserBuilder<? extends F>> F setCount(F functionBuilder, int count, boolean add) {
        functionBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)count), (boolean)add));
        return functionBuilder;
    }

    public static <F extends FunctionUserBuilder<? extends F>> F setCountBetween(F functionBuilder, float min, float max) {
        functionBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
        return functionBuilder;
    }

    public static <F extends FunctionUserBuilder<? extends F>> F setCountBetween(F functionBuilder, float min, float max, boolean add) {
        functionBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max), (boolean)add));
        return functionBuilder;
    }

    public static LootPool.Builder lootPoolOf(ItemLike item) {
        return DataGenHelper.lootPoolOf(LootItem.m_79579_((ItemLike)item));
    }

    public static LootPool.Builder lootPoolOf(ItemLike item, int count) {
        return DataGenHelper.lootPoolOf(LootItem.m_79579_((ItemLike)item), count);
    }

    public static LootPool.Builder lootPoolOf(ItemLike item, float min, float max) {
        return DataGenHelper.lootPoolOf(LootItem.m_79579_((ItemLike)item), min, max);
    }

    public static <E extends LootPoolEntryContainer.Builder<? extends E>> LootPool.Builder lootPoolOf(E entry) {
        return LootPool.m_79043_().m_79076_(entry);
    }

    public static <E extends LootPoolEntryContainer.Builder<? extends E>> LootPool.Builder lootPoolOf(E entry, int count) {
        return DataGenHelper.setCount(LootPool.m_79043_().m_79076_(entry), count);
    }

    public static <E extends LootPoolEntryContainer.Builder<? extends E>> LootPool.Builder lootPoolOf(E entry, float min, float max) {
        return DataGenHelper.setCountBetween(LootPool.m_79043_().m_79076_(entry), min, max);
    }
}

