/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.BlockCompartmentEntity;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class NoteBlockCompartmentEntity
extends BlockCompartmentEntity {
    public static final byte PLAY_NOTE_EVENT = 10;
    @Nullable
    private ResourceLocation noteBlockSound;

    public NoteBlockCompartmentEntity(CompartmentType<? extends NoteBlockCompartmentEntity> compartmentType, Level level) {
        super((CompartmentType<? extends BlockCompartmentEntity>)compartmentType, level);
    }

    public NoteBlockCompartmentEntity(CompartmentType<? extends NoteBlockCompartmentEntity> compartmentType, Level level, ItemStack itemStack) {
        super(compartmentType, level, itemStack);
        CompoundTag blockEntityData = BlockItem.m_186336_((ItemStack)itemStack);
        if (blockEntityData != null) {
            this.readCommonSaveData(blockEntityData);
        }
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.noteBlockSound != null) {
            compoundTag.m_128359_("note_block_sound", this.noteBlockSound.toString());
        }
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.readCommonSaveData(compoundTag);
    }

    private void readCommonSaveData(CompoundTag compoundTag) {
        if (compoundTag.m_128425_("note_block_sound", 8)) {
            this.noteBlockSound = ResourceLocation.m_135820_((String)compoundTag.m_128461_("note_block_sound"));
        }
    }

    @Override
    protected void onHurt(DamageSource damageSource) {
        Entity entity;
        if (!this.m_9236_().f_46443_ && (entity = damageSource.m_7640_()) instanceof Player) {
            Player player = (Player)entity;
            this.playNote((Entity)player);
            player.m_36220_(Stats.f_12959_);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldStack = player.m_21120_(hand);
        if (player.m_6144_() && heldStack.m_41619_()) {
            this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)NoteBlock.f_55011_, (Comparable)NoteBlockInstrument.HARP));
            this.playNote((Entity)player);
            return InteractionResult.CONSUME;
        }
        Item item = heldStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)NoteBlock.f_55011_, (Comparable)blockItem.m_40614_().m_49966_().m_280603_()));
            CompoundTag blockEntityData = BlockItem.m_186336_((ItemStack)heldStack);
            if (blockEntityData != null) {
                this.readCommonSaveData(blockEntityData);
            }
            this.playNote((Entity)player);
            return InteractionResult.CONSUME;
        }
        this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61122_((Property)NoteBlock.f_55013_));
        this.playNote((Entity)player);
        player.m_36220_(Stats.f_12960_);
        return InteractionResult.CONSUME;
    }

    public void m_7822_(byte eventId) {
        if (eventId != 10) {
            super.m_7822_(eventId);
        }
        int noteIndex = (Integer)this.getDisplayBlockState().m_61143_((Property)NoteBlock.f_55013_);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_(), this.m_20186_() + 1.2, this.m_20189_(), (double)noteIndex / 24.0, 0.0, 0.0);
    }

    private void playNote(Entity player) {
        float pitch;
        NoteBlockInstrument instrument;
        if (((NoteBlockInstrument)this.getDisplayBlockState().m_61143_((Property)NoteBlock.f_55011_)).m_262503_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)10);
        }
        if ((instrument = (NoteBlockInstrument)this.getDisplayBlockState().m_61143_((Property)NoteBlock.f_55011_)).m_262503_()) {
            int noteIndex = (Integer)this.getDisplayBlockState().m_61143_((Property)NoteBlock.f_55013_);
            pitch = NoteBlock.m_276981_((int)noteIndex);
        } else {
            pitch = 1.0f;
        }
        Holder soundEvent = instrument.m_262394_() && this.noteBlockSound != null ? Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)this.noteBlockSound)) : instrument.m_263188_();
        this.playSound((SoundEvent)soundEvent.m_203334_(), SoundSource.RECORDS, 3.0f, pitch);
        this.m_146852_(GameEvent.f_223699_, player);
    }
}

