/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.LidCompartment;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.RandomizableContainerCompartmentEntity;
import com.alekiponi.alekiships.util.CommonHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ChestCompartmentEntity
extends RandomizableContainerCompartmentEntity.RandomizableContainerMenuCompartmentEntity
implements LidCompartment {
    public static final byte CONTAINER_OPEN = 1;
    public static final byte CONTAINER_CLOSE = 2;
    public static final int SLOT_COUNT = 27;
    private final ChestLidController chestLidController = new ChestLidController();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
            ChestCompartmentEntity.this.playSound(SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }

        protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
            ChestCompartmentEntity.this.playSound(SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }

        protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int count, int openCount) {
            ChestCompartmentEntity.this.signalOpenCount(level, (byte)openCount);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ChestMenu)) {
                return false;
            }
            Container container = ((ChestMenu)player.f_36096_).m_39261_();
            return container == ChestCompartmentEntity.this;
        }
    };

    public ChestCompartmentEntity(CompartmentType<? extends ChestCompartmentEntity> compartmentType, Level level) {
        this(compartmentType, level, 27);
    }

    public ChestCompartmentEntity(CompartmentType<? extends ChestCompartmentEntity> compartmentType, Level level, ItemStack itemStack) {
        this(compartmentType, level, 27, itemStack);
    }

    protected ChestCompartmentEntity(CompartmentType<? extends ChestCompartmentEntity> compartmentType, Level level, int slotCount) {
        super((CompartmentType<? extends RandomizableContainerCompartmentEntity.RandomizableContainerMenuCompartmentEntity>)compartmentType, level, slotCount);
    }

    protected ChestCompartmentEntity(CompartmentType<? extends ChestCompartmentEntity> compartmentType, Level level, int slotCount, ItemStack itemStack) {
        super((CompartmentType<? extends RandomizableContainerCompartmentEntity.RandomizableContainerMenuCompartmentEntity>)compartmentType, level, slotCount, itemStack);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.chestLidController.m_155374_();
        if (!this.m_213877_() && !this.m_9236_().m_5776_()) {
            this.openersCounter.m_155476_(this.m_9236_(), this.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    public void m_7822_(byte dataID) {
        switch (dataID) {
            case 1: {
                this.chestLidController.m_155377_(true);
                break;
            }
            case 2: {
                this.chestLidController.m_155377_(false);
            }
        }
        super.m_7822_(dataID);
    }

    @Override
    protected void onHurt(DamageSource damageSource) {
        CommonHelper.playHitSound(this::playSound, SoundType.f_56736_);
    }

    @Override
    protected void onPlaced() {
        CommonHelper.playPlaceSound(this::playSound, SoundType.f_56736_);
    }

    @Override
    protected void onBreak() {
        super.onBreak();
        CommonHelper.playBreakSound(this::playSound, SoundType.f_56736_);
    }

    public void m_5856_(Player player) {
        if (!this.m_213877_() && !player.m_5833_() || !this.m_20159_()) {
            this.openersCounter.m_155452_(player, this.m_9236_(), this.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public void m_5785_(Player player) {
        if (!this.m_213877_() && !player.m_5833_() || !this.m_20159_()) {
            this.openersCounter.m_155468_(player, this.m_9236_(), this.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return ChestMenu.m_39237_((int)id, (Inventory)playerInventory, (Container)this);
    }

    @Override
    public float getOpenNess(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    private void signalOpenCount(Level level, byte openCount) {
        level.m_7605_((Entity)this, openCount > 0 ? (byte)1 : 2);
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((ItemLike)Blocks.f_50087_.m_5456_());
    }

    @Override
    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Blocks.f_50087_.m_5456_());
    }
}

