/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.BlockCompartment;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.ContainerCompartmentEntity;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class BrewingStandCompartmentEntity
extends ContainerCompartmentEntity.ContainerMenuCompartmentEntity
implements WorldlyContainer,
BlockCompartment {
    public static final int SLOT_COUNT = 5;
    public static final String FUEL_KEY = "Fuel";
    public static final String BREW_TIME_KEY = "BrewTime";
    public static final int INGREDIENT_SLOT = 3;
    public static final int FUEL_SLOT = 4;
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
    private static final EntityDataAccessor<BlockState> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.m_135353_(BrewingStandCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    protected int brewTime;
    protected int fuel;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int dataType) {
            return switch (dataType) {
                case 0 -> BrewingStandCompartmentEntity.this.brewTime;
                case 1 -> BrewingStandCompartmentEntity.this.fuel;
                default -> 0;
            };
        }

        public void m_8050_(int dataType, int dataValue) {
            switch (dataType) {
                case 0: {
                    BrewingStandCompartmentEntity.this.brewTime = dataValue;
                    break;
                }
                case 1: {
                    BrewingStandCompartmentEntity.this.fuel = dataValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private LazyOptional<? extends IItemHandler>[] directionalHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    @Nullable
    private boolean[] lastPotionCount;
    @Nullable
    private Item ingredient;

    public BrewingStandCompartmentEntity(CompartmentType<? extends BrewingStandCompartmentEntity> compartmentType, Level level) {
        super((CompartmentType<? extends ContainerCompartmentEntity.ContainerMenuCompartmentEntity>)compartmentType, level, 5);
    }

    public BrewingStandCompartmentEntity(CompartmentType<? extends BrewingStandCompartmentEntity> compartmentType, Level level, ItemStack itemStack) {
        super((CompartmentType<? extends ContainerCompartmentEntity.ContainerMenuCompartmentEntity>)compartmentType, level, 5, itemStack);
        this.setDisplayBlockState(Blocks.f_50255_.m_49966_());
    }

    private static void doBrew(Level level, BlockPos blockPos, NonNullList<ItemStack> itemStacks) {
        if (ForgeEventFactory.onPotionAttemptBrew(itemStacks)) {
            return;
        }
        ItemStack itemstack = (ItemStack)itemStacks.get(3);
        BrewingRecipeRegistry.brewPotions(itemStacks, (ItemStack)itemstack, (int[])SLOTS_FOR_SIDES);
        ForgeEventFactory.onPotionBrewed(itemStacks);
        if (itemstack.hasCraftingRemainingItem()) {
            ItemStack craftingRemainder = itemstack.getCraftingRemainingItem();
            itemstack.m_41774_(1);
            if (itemstack.m_41619_()) {
                itemStacks.set(3, (Object)craftingRemainder);
                level.m_46796_(1035, blockPos, 0);
                return;
            }
            Containers.m_18992_((Level)level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (ItemStack)craftingRemainder);
            itemStacks.set(3, (Object)itemstack);
            level.m_46796_(1035, blockPos, 0);
            return;
        }
        itemstack.m_41774_(1);
        itemStacks.set(3, (Object)itemstack);
        level.m_46796_(1035, blockPos, 0);
    }

    private static boolean isBrewable(NonNullList<ItemStack> itemStacks) {
        ItemStack itemstack = (ItemStack)itemStacks.get(3);
        if (!itemstack.m_41619_()) {
            return BrewingRecipeRegistry.canBrew(itemStacks, (ItemStack)itemstack, (int[])SLOTS_FOR_SIDES);
        }
        if (itemstack.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_((ItemStack)itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemStack = (ItemStack)itemStacks.get(i);
            if (itemStack.m_41619_() || !PotionBrewing.m_43508_((ItemStack)itemStack, (ItemStack)itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.m_6084_() && this.f_19797_ % 5 == 0) {
                double x = this.m_20185_() - 0.1 + this.f_19796_.m_188500_() * 0.2;
                double y = this.m_20186_() + 0.5 + this.f_19796_.m_188500_() * 0.3;
                double z = this.m_20189_() - 0.1 + this.f_19796_.m_188500_() * 0.2;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
            }
            return;
        }
        ItemStack fuelStack = this.m_8020_(4);
        if (this.fuel <= 0 && fuelStack.m_150930_(Items.f_42593_)) {
            this.fuel = 20;
            fuelStack.m_41774_(1);
        }
        boolean canBrew = BrewingStandCompartmentEntity.isBrewable((NonNullList<ItemStack>)this.itemStacks);
        ItemStack ingredientStack = this.m_8020_(3);
        if (this.brewTime > 0) {
            --this.brewTime;
            if (this.brewTime == 0 && canBrew) {
                BrewingStandCompartmentEntity.doBrew(this.m_9236_(), this.m_20183_(), (NonNullList<ItemStack>)this.itemStacks);
            } else if (!canBrew || !ingredientStack.m_150930_(this.ingredient)) {
                this.brewTime = 0;
            }
        } else if (canBrew && this.fuel > 0) {
            --this.fuel;
            this.brewTime = 400;
            this.ingredient = ingredientStack.m_41720_();
        }
        boolean[] potionBits = this.getPotionBits();
        if (!Arrays.equals(potionBits, this.lastPotionCount)) {
            this.lastPotionCount = potionBits;
            BlockState blockstate = this.getDisplayBlockState();
            if (!(blockstate.m_60734_() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.f_50905_.length; ++i) {
                blockstate = (BlockState)blockstate.m_61124_((Property)BrewingStandBlock.f_50905_[i], (Comparable)Boolean.valueOf(potionBits[i]));
            }
            this.setDisplayBlockState(blockstate);
        }
    }

    private boolean[] getPotionBits() {
        boolean[] potionBits = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            potionBits[i] = true;
        }
        return potionBits;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_DISPLAY_BLOCK, (Object)Blocks.f_50016_.m_49966_());
    }

    @Override
    protected void onHurt(DamageSource damageSource) {
        BlockCompartment.playHitSound(this);
    }

    @Override
    protected void onPlaced() {
        BlockCompartment.playPlaceSound(this);
    }

    @Override
    protected void onBreak() {
        super.onBreak();
        BlockCompartment.playBreakSound(this);
    }

    public boolean m_7013_(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 3) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)itemStack);
        }
        if (slotIndex == 4) {
            return itemStack.m_150930_(Items.f_42593_);
        }
        return BrewingRecipeRegistry.isValidInput((ItemStack)itemStack) && this.m_8020_(slotIndex).m_41619_();
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return direction == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int slotIndex, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(slotIndex, itemStack);
    }

    public boolean m_7157_(int slotIndex, ItemStack itemStack, Direction direction) {
        return slotIndex != 3 || itemStack.m_150930_(Items.f_42590_);
    }

    @Override
    public BlockState getDisplayBlockState() {
        return (BlockState)this.f_19804_.m_135370_(DATA_ID_DISPLAY_BLOCK);
    }

    @Override
    public void setDisplayBlockState(BlockState blockState) {
        this.f_19804_.m_135381_(DATA_ID_DISPLAY_BLOCK, (Object)blockState);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.loadCommonNBTData(compoundTag);
        BlockCompartment.readBlockstate(this, compoundTag);
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.saveCommonNBTData(compoundTag);
        BlockCompartment.saveBlockstate(this, compoundTag);
    }

    @Override
    public void loadFromStackNBT(CompoundTag compoundTag) {
        super.loadFromStackNBT(compoundTag);
        this.loadCommonNBTData(compoundTag);
    }

    @Override
    public CompoundTag saveForItemStack() {
        CompoundTag compoundTag = super.saveForItemStack();
        this.saveCommonNBTData(compoundTag);
        return compoundTag;
    }

    private void loadCommonNBTData(CompoundTag compoundTag) {
        if (compoundTag.m_128425_(BREW_TIME_KEY, 2)) {
            this.brewTime = compoundTag.m_128448_(BREW_TIME_KEY);
        }
        if (compoundTag.m_128425_(FUEL_KEY, 1)) {
            this.fuel = compoundTag.m_128445_(FUEL_KEY);
        }
    }

    private void saveCommonNBTData(CompoundTag compoundTag) {
        compoundTag.m_128376_(BREW_TIME_KEY, (short)this.brewTime);
        compoundTag.m_128344_(FUEL_KEY, (byte)this.fuel);
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    @Override
    protected ItemStack getDropStack() {
        return new ItemStack((ItemLike)Items.f_42543_);
    }

    @Override
    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Items.f_42543_);
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new BrewingStandMenu(id, playerInventory, (Container)this, this.dataAccess);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.m_6084_() || facing == null || capability != ForgeCapabilities.ITEM_HANDLER) {
            return super.getCapability(capability, facing);
        }
        if (facing == Direction.UP) {
            return this.directionalHandlers[0].cast();
        }
        if (facing == Direction.DOWN) {
            return this.directionalHandlers[1].cast();
        }
        return this.directionalHandlers[2].cast();
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        Arrays.stream(this.directionalHandlers).forEach(LazyOptional::invalidate);
    }

    @Override
    public void reviveCaps() {
        super.reviveCaps();
        this.directionalHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

