/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.BlockCompartment;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.RandomizableContainerCompartmentEntity;
import com.alekiponi.alekiships.util.advancements.AlekiShipsAdvancements;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BarrelCompartmentEntity
extends RandomizableContainerCompartmentEntity.RandomizableContainerMenuCompartmentEntity
implements BlockCompartment {
    public static final int SLOT_COUNT = 27;
    private static final EntityDataAccessor<BlockState> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.m_135353_(BarrelCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
            BarrelCompartmentEntity.this.playSound(SoundEvents.f_11725_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            BarrelCompartmentEntity.this.setDisplayBlockState((BlockState)blockState.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(true)));
        }

        protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
            BarrelCompartmentEntity.this.playSound(SoundEvents.f_11724_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            BarrelCompartmentEntity.this.setDisplayBlockState((BlockState)blockState.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(false)));
        }

        protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int count, int openCount) {
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ChestMenu)) {
                return false;
            }
            Container container = ((ChestMenu)player.f_36096_).m_39261_();
            return container == BarrelCompartmentEntity.this;
        }
    };

    public BarrelCompartmentEntity(CompartmentType<? extends BarrelCompartmentEntity> compartmentType, Level level) {
        super((CompartmentType<? extends RandomizableContainerCompartmentEntity.RandomizableContainerMenuCompartmentEntity>)compartmentType, level, 27);
    }

    public BarrelCompartmentEntity(CompartmentType<? extends BarrelCompartmentEntity> compartmentType, Level level, ItemStack itemStack) {
        super((CompartmentType<? extends RandomizableContainerCompartmentEntity.RandomizableContainerMenuCompartmentEntity>)compartmentType, level, 27, itemStack);
        this.setDisplayBlockState((BlockState)((BlockState)Blocks.f_50618_.m_49966_().m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.UP)).m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_DISPLAY_BLOCK, (Object)Blocks.f_50016_.m_49966_());
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.m_20159_() && !player.m_36341_()) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        InteractionResult interactionResult = super.m_6096_(player, hand);
        if (interactionResult.m_19077_()) {
            player.m_36220_(Stats.f_12971_);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return interactionResult;
    }

    @Override
    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        if (this.m_20160_() && !this.m_20159_() && this.everyNthTickUnique(5) && (entity = this.m_146895_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (this.m_20069_()) {
                AlekiShipsAdvancements.RIDE_BARREL.trigger(serverPlayer);
            }
        }
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_() || !this.m_20159_()) {
            this.openersCounter.m_155452_(player, this.m_9236_(), this.m_20183_(), this.getDisplayBlockState());
        }
    }

    @Override
    public void m_5785_(Player player) {
        if (!player.m_5833_() || !this.m_20159_()) {
            this.openersCounter.m_155468_(player, this.m_9236_(), this.m_20183_(), this.getDisplayBlockState());
        }
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        BlockCompartment.saveBlockstate(this, compoundTag);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        BlockCompartment.readBlockstate(this, compoundTag);
    }

    @Override
    protected void onHurt(DamageSource damageSource) {
        BlockCompartment.playHitSound(this);
    }

    public double m_6048_() {
        return 0.4;
    }

    @Override
    public BlockState getDisplayBlockState() {
        return this.m_20159_() ? (BlockState)this.f_19804_.m_135370_(DATA_ID_DISPLAY_BLOCK) : (BlockState)((BlockState)this.f_19804_.m_135370_(DATA_ID_DISPLAY_BLOCK)).m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void setDisplayBlockState(BlockState blockState) {
        this.f_19804_.m_135381_(DATA_ID_DISPLAY_BLOCK, (Object)blockState);
    }

    @Override
    protected void onPlaced() {
        BlockCompartment.playPlaceSound(this);
    }

    @Override
    protected void onBreak() {
        super.onBreak();
        BlockCompartment.playBreakSound(this);
    }

    @Override
    public double getBuoyancy() {
        return this.f_19797_ % 21 > 10 ? -0.01 : 0.01;
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((ItemLike)this.getDisplayBlockState().m_60734_());
    }

    @Override
    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDisplayBlockState().m_60734_());
    }

    @Override
    public AbstractCompartmentEntity.RidingPose getRidingPose() {
        return AbstractCompartmentEntity.RidingPose.STANDING;
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return ChestMenu.m_39237_((int)id, (Inventory)playerInventory, (Container)this);
    }
}

