/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper;

import com.alekiponi.alekiships.common.entity.AlekiShipsEntities;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.util.AlekiShipsTags;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.PlayMessages;
import oshi.util.tuples.Pair;

public class CompartmentType<T extends AbstractCompartmentEntity>
extends EntityType<T> {
    private static final ArrayList<Pair<Supplier<? extends CompartmentType<? extends AbstractCompartmentEntity>>, Predicate<ItemStack>>> COMPARTMENT_TYPES = new ArrayList();
    @Nullable
    private final StackCompartmentFactory<T> stackCompartmentFactory;
    private final BasicCompartmentFactory<T> basicCompartmentFactory;

    public CompartmentType(BasicCompartmentFactory<T> basicCompartmentFactory, MobCategory mobCategory, boolean serialize, boolean summon, boolean fireImmune, boolean canSpawnFarFromPlayer, ImmutableSet<Block> immuneTo, EntityDimensions dimensions, int clientTrackingRange, int updateInterval, FeatureFlagSet requiredFeatures, @Nullable StackCompartmentFactory<T> stackCompartmentFactory) {
        super((entityType, level) -> null, mobCategory, serialize, summon, fireImmune, canSpawnFarFromPlayer, immuneTo, dimensions, clientTrackingRange, updateInterval, requiredFeatures);
        this.basicCompartmentFactory = basicCompartmentFactory;
        this.stackCompartmentFactory = stackCompartmentFactory;
    }

    public CompartmentType(BasicCompartmentFactory<T> basicCompartmentFactory, MobCategory mobCategory, boolean serialize, boolean summon, boolean fireImmune, boolean canSpawnFarFromPlayer, ImmutableSet<Block> immuneTo, EntityDimensions dimensions, int clientTrackingRange, int updateInterval, FeatureFlagSet requiredFeatures, Predicate<EntityType<?>> velocityUpdateSupplier, ToIntFunction<EntityType<?>> trackingRangeSupplier, ToIntFunction<EntityType<?>> updateIntervalSupplier, @Nullable BiFunction<PlayMessages.SpawnEntity, Level, T> customClientFactory, @Nullable StackCompartmentFactory<T> stackCompartmentFactory) {
        super((entityType, level) -> null, mobCategory, serialize, summon, fireImmune, canSpawnFarFromPlayer, immuneTo, dimensions, clientTrackingRange, updateInterval, requiredFeatures, velocityUpdateSupplier, trackingRangeSupplier, updateIntervalSupplier, customClientFactory);
        this.basicCompartmentFactory = basicCompartmentFactory;
        this.stackCompartmentFactory = stackCompartmentFactory;
    }

    public static <S extends Supplier<? extends CompartmentType<?>>> S register(S compartmentTypeSupplier, Predicate<ItemStack> predicate) {
        COMPARTMENT_TYPES.add((Pair<Supplier<? extends CompartmentType<? extends AbstractCompartmentEntity>>, Predicate<ItemStack>>)new Pair(Objects.requireNonNull(compartmentTypeSupplier), Objects.requireNonNull(predicate)));
        return compartmentTypeSupplier;
    }

    public static Optional<CompartmentType<?>> fromStack(ItemStack itemStack) {
        if (!itemStack.m_204117_(AlekiShipsTags.Items.CAN_PLACE_IN_COMPARTMENTS)) {
            return Optional.empty();
        }
        for (Pair<Supplier<? extends CompartmentType<? extends AbstractCompartmentEntity>>, Predicate<ItemStack>> predicatePair : COMPARTMENT_TYPES) {
            if (!((Predicate)predicatePair.getB()).test(itemStack)) continue;
            return Optional.of((CompartmentType)((Object)((Supplier)predicatePair.getA()).get()));
        }
        if (itemStack.m_41720_() instanceof BlockItem) {
            return Optional.of((CompartmentType)((Object)AlekiShipsEntities.BLOCK_COMPARTMENT_ENTITY.get()));
        }
        return Optional.empty();
    }

    @Nullable
    public T create(Level level) {
        return !this.m_245993_(level.m_246046_()) ? null : (T)this.basicCompartmentFactory.create(this, level);
    }

    @Nullable
    public T create(Level level, ItemStack itemStack) {
        if (!this.m_245993_(level.m_246046_())) {
            return null;
        }
        return this.stackCompartmentFactory != null ? this.stackCompartmentFactory.create(this, level, itemStack) : this.basicCompartmentFactory.create(this, level);
    }

    @FunctionalInterface
    public static interface BasicCompartmentFactory<T extends AbstractCompartmentEntity> {
        @Nullable
        public T create(CompartmentType<T> var1, Level var2);
    }

    @FunctionalInterface
    public static interface StackCompartmentFactory<T extends AbstractCompartmentEntity> {
        @Nullable
        public T create(CompartmentType<T> var1, Level var2, ItemStack var3);
    }

    public static class Builder<T extends AbstractCompartmentEntity>
    extends EntityType.Builder<T> {
        private final BasicCompartmentFactory<T> basicCompartmentFactory;
        @Nullable
        private final StackCompartmentFactory<T> stackCompartmentFactory;
        private Predicate<EntityType<?>> velocityUpdateSupplier = entityType -> true;
        private ToIntFunction<EntityType<?>> trackingRangeSupplier = entityType -> entityType.f_20542_;
        private ToIntFunction<EntityType<?>> updateIntervalSupplier = entityType -> entityType.f_20543_;
        @Nullable
        private BiFunction<PlayMessages.SpawnEntity, Level, T> customClientFactory;

        private Builder(BasicCompartmentFactory<T> basicCompartmentFactory, @Nullable StackCompartmentFactory<T> stackCompartmentFactory, MobCategory mobCategory) {
            super(null, mobCategory);
            this.basicCompartmentFactory = basicCompartmentFactory;
            this.stackCompartmentFactory = stackCompartmentFactory;
        }

        public static <T extends AbstractCompartmentEntity> Builder<T> of(BasicCompartmentFactory<T> basicCompartmentFactory, StackCompartmentFactory<T> stackCompartmentFactory) {
            return new Builder<T>(basicCompartmentFactory, stackCompartmentFactory, MobCategory.MISC);
        }

        public static <T extends AbstractCompartmentEntity> Builder<T> of(BasicCompartmentFactory<T> basicCompartmentFactory, @Nullable StackCompartmentFactory<T> stackCompartmentFactory, MobCategory mobCategory) {
            return new Builder<T>(basicCompartmentFactory, stackCompartmentFactory, mobCategory);
        }

        public static <T extends AbstractCompartmentEntity> Builder<T> createBasic(BasicCompartmentFactory<T> basicCompartmentFactory) {
            return Builder.createBasic(basicCompartmentFactory, MobCategory.MISC);
        }

        public static <T extends AbstractCompartmentEntity> Builder<T> createBasic(BasicCompartmentFactory<T> basicCompartmentFactory, MobCategory mobCategory) {
            return Builder.of(basicCompartmentFactory, null, mobCategory);
        }

        public static <T extends AbstractCompartmentEntity> Builder<T> createNothing2(MobCategory mobCategory) {
            return Builder.of((entityType, level) -> null, null, mobCategory);
        }

        public Builder<T> sized(float pWidth, float pHeight) {
            return (Builder)super.m_20699_(pWidth, pHeight);
        }

        public Builder<T> noSummon() {
            return (Builder)super.m_20698_();
        }

        public Builder<T> noSave() {
            return (Builder)super.m_20716_();
        }

        public Builder<T> fireImmune() {
            return (Builder)super.m_20719_();
        }

        public Builder<T> immuneTo(Block ... pBlocks) {
            return (Builder)super.m_20714_(pBlocks);
        }

        public Builder<T> canSpawnFarFromPlayer() {
            return (Builder)super.m_20720_();
        }

        public Builder<T> clientTrackingRange(int pClientTrackingRange) {
            return (Builder)super.m_20702_(pClientTrackingRange);
        }

        public Builder<T> updateInterval(int pUpdateInterval) {
            return (Builder)super.m_20717_(pUpdateInterval);
        }

        public Builder<T> requiredFeatures(FeatureFlag ... pRequiredFeatures) {
            return (Builder)super.m_246346_(pRequiredFeatures);
        }

        public Builder<T> setUpdateInterval(int interval) {
            this.updateIntervalSupplier = t -> interval;
            return this;
        }

        public Builder<T> setTrackingRange(int range) {
            this.trackingRangeSupplier = t -> range;
            return this;
        }

        public Builder<T> setShouldReceiveVelocityUpdates(boolean value) {
            this.velocityUpdateSupplier = t -> value;
            return this;
        }

        public Builder<T> setCustomClientFactory(BiFunction<PlayMessages.SpawnEntity, Level, T> customClientFactory) {
            this.customClientFactory = customClientFactory;
            return this;
        }

        public CompartmentType<T> build(String key) {
            if (this.f_20688_) {
                Util.m_137456_((DSL.TypeReference)References.f_16785_, (String)key);
            }
            return new CompartmentType<T>(this.basicCompartmentFactory, this.f_20686_, this.f_20688_, this.f_20689_, this.f_20690_, this.f_20691_, (ImmutableSet<Block>)this.f_20687_, this.f_20694_, this.f_20692_, this.f_20693_, this.f_244453_, this.velocityUpdateSupplier, this.trackingRangeSupplier, this.updateIntervalSupplier, this.customClientFactory, this.stackCompartmentFactory);
        }
    }
}

