/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclecapability;

import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CleatEntity;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public interface IHaveCleats {
    public int[] getCleatIndices();

    public float getCleatMovementMultiplier();

    private ArrayList<CleatEntity> getCleats(AbstractVehicle vehicle) {
        ArrayList<CleatEntity> list = new ArrayList<CleatEntity>();
        if (vehicle.m_20197_().size() == vehicle.getMaxPassengers()) {
            for (int i : this.getCleatIndices()) {
                Entity entity = ((Entity)vehicle.m_20197_().get(i)).m_146895_();
                if (!(entity instanceof CleatEntity)) continue;
                CleatEntity cleat = (CleatEntity)entity;
                list.add(cleat);
            }
        }
        return list;
    }

    default public ArrayList<CleatEntity> getCleats() {
        return this.getCleats((AbstractVehicle)((Object)this));
    }

    default public boolean isBeingTowed(AbstractVehicle vehicle) {
        Iterator<CleatEntity> iterator;
        if (vehicle.m_20197_().size() == vehicle.getMaxPassengers() && (iterator = this.getCleats().iterator()).hasNext()) {
            CleatEntity cleat = iterator.next();
            return cleat.isLeashed() && vehicle.m_20184_().m_82553_() != 0.0;
        }
        return false;
    }

    default public boolean isBeingTowed() {
        return this.isBeingTowed((AbstractVehicle)((Object)this));
    }

    default public void tickCleatInput() {
        AbstractVehicle vehicle = (AbstractVehicle)((Object)this);
        for (CleatEntity cleat : this.getCleats()) {
            Entity leashHolder;
            if (!cleat.isLeashed() || (leashHolder = cleat.getLeashHolder()) == null) continue;
            if (leashHolder instanceof Player) {
                Player player = (Player)leashHolder;
                if (vehicle.collectEntitesToTakeWith().contains(player)) {
                    return;
                }
                if (cleat.m_20270_(leashHolder) > 4.0f) {
                    Vec3 vectorToVehicle = leashHolder.m_20318_(0.0f).m_82505_(cleat.m_20318_(0.0f)).m_82541_();
                    Vec3 movementVector = new Vec3(vectorToVehicle.f_82479_ * (double)-0.04f, vehicle.m_20184_().f_82480_, vectorToVehicle.f_82481_ * (double)-0.04f);
                    double vehicleSize = Mth.m_14036_((float)vehicle.m_20205_(), (float)1.0f, (float)100.0f);
                    movementVector = movementVector.m_82542_(1.0 / vehicleSize, 0.0, 1.0 / vehicleSize);
                    double d0 = leashHolder.m_20318_((float)0.0f).f_82479_ - vehicle.m_20185_();
                    double d2 = leashHolder.m_20318_((float)0.0f).f_82481_ - vehicle.m_20189_();
                    float finalRotation = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
                    double difference = leashHolder.m_20186_() - vehicle.m_20186_();
                    if (leashHolder.m_20186_() > vehicle.m_20186_() && difference >= 0.4 && difference <= 1.0 && vehicle.m_20184_().m_82553_() < (double)0.02f) {
                        vehicle.m_6034_(vehicle.m_20185_(), vehicle.m_20186_() + (double)0.55f, vehicle.m_20189_());
                    }
                    float approach = Mth.m_14148_((float)vehicle.m_146908_(), (float)finalRotation, (float)6.0f);
                    vehicle.m_20256_(vehicle.m_20184_().m_82549_(movementVector));
                    vehicle.setDeltaRotation(-1.0f * (vehicle.m_146908_() - approach));
                }
            }
            if (!(leashHolder instanceof HangingEntity) || vehicle.getStatus() == AbstractVehicle.MediumStatus.ON_LAND) continue;
            Vec3 vectorToVehicle = leashHolder.m_20318_(0.0f).m_82505_(cleat.m_20318_(0.0f)).m_82541_();
            Vec3 movementVector = new Vec3(vectorToVehicle.f_82479_ * (double)-0.005f, vehicle.m_20184_().f_82480_, vectorToVehicle.f_82481_ * (double)-0.005f);
            double d0 = leashHolder.m_20318_((float)0.0f).f_82479_ - vehicle.m_20185_();
            double d2 = leashHolder.m_20318_((float)0.0f).f_82481_ - vehicle.m_20189_();
            float finalRotation = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
            float approach = Mth.m_14148_((float)vehicle.m_146908_(), (float)finalRotation, (float)0.5f);
            if (Mth.m_14145_((float)vehicle.m_146908_(), (float)finalRotation) < 4.0f) {
                vehicle.setDeltaRotation(0.0f);
                vehicle.m_146922_(vehicle.m_146908_());
            } else {
                vehicle.setDeltaRotation(-1.0f * (vehicle.m_146908_() - approach));
            }
            if (cleat.m_20270_(leashHolder) > 2.0f) {
                vehicle.m_20256_(movementVector);
                continue;
            }
            Player player = vehicle.m_9236_().m_45930_((Entity)vehicle, 96.0);
            vehicle.m_20256_(Vec3.f_82478_);
        }
    }
}

