/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity;

import com.alekiponi.alekiships.common.entity.AlekiShipsEntities;
import com.alekiponi.alekiships.common.entity.CannonEntity;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.util.CannonballExplosion;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class CannonballEntity
extends Projectile {
    public CannonballEntity(EntityType<? extends CannonballEntity> entityType, Level level) {
        super(entityType, level);
    }

    public CannonballEntity(double x, double y, double z, Level level) {
        super((EntityType)AlekiShipsEntities.CANNONBALL_ENTITY.get(), level);
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20090_();
    }

    public CannonballEntity(CannonEntity cannonEntity) {
        this(cannonEntity.m_20185_(), cannonEntity.m_20186_(), cannonEntity.m_20189_(), cannonEntity.m_9236_());
        this.shoot(cannonEntity);
    }

    protected void m_8097_() {
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        this.explode((float)Math.min(this.m_20184_().m_82553_() * 2.0, 4.0));
        this.m_146870_();
    }

    public void shoot(CannonEntity cannonEntity) {
        this.m_5602_(cannonEntity);
        this.m_37251_(cannonEntity, cannonEntity.m_146909_(), cannonEntity.m_146908_(), 0.0f, 6.0f, 0.0f);
        if (cannonEntity.m_20159_()) {
            this.m_20256_(this.m_20184_().m_82549_(cannonEntity.m_20201_().m_20184_()));
        }
    }

    public void m_8119_() {
        float inertia;
        Entity owner = this.m_19749_();
        if ((owner != null && owner.m_213877_() || !this.m_9236_().m_46805_(this.m_20183_())) && !this.m_9236_().f_46443_) {
            this.m_146870_();
            return;
        }
        super.m_8119_();
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        if (hitResult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
            this.m_6532_(hitResult);
        }
        this.m_20101_();
        Vec3 movement = this.m_20184_();
        double nextX = this.m_20185_() + movement.f_82479_;
        double nextY = this.m_20186_() + movement.f_82480_;
        double nextZ = this.m_20189_() + movement.f_82481_;
        ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, nextX - movement.f_82479_ * 0.25, nextY - movement.f_82480_ * 0.25, nextZ - movement.f_82481_ * 0.25, movement.f_82479_, movement.f_82480_, movement.f_82481_);
            }
            inertia = 0.8f;
        } else {
            inertia = 0.98f;
        }
        this.m_20256_(movement.m_82520_(0.0, -0.1, 0.0).m_82490_((double)inertia));
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123778_, nextX, nextY + 0.5, nextZ, 0.0, 0.0, 0.0);
        this.m_6034_(nextX, nextY, nextZ);
    }

    protected void explode(float radius) {
        Level level = this.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        Explosion.BlockInteraction blockInteraction = level.m_46469_().m_46207_(GameRules.f_254705_) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
        CannonballExplosion explosion = new CannonballExplosion(level, (Entity)this, null, null, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), radius, false, blockInteraction);
        if (ForgeEventFactory.onExplosionStart((Level)level, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!explosion.m_254884_()) {
            explosion.m_46080_();
        }
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            if (!(serverPlayer.m_20275_(x, y, z) < 4096.0)) continue;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverPlayer)));
        }
    }

    protected boolean m_5603_(Entity target) {
        if (target.m_20201_() instanceof AbstractVehicle && this.m_19749_() != null && target.m_20201_().m_7306_(this.m_19749_().m_20201_())) {
            return false;
        }
        if (!target.m_271807_()) {
            return false;
        }
        return !this.m_20365_(target) && !target.f_19794_;
    }

    public AABB m_6921_() {
        float bbRadius = 2.0f;
        Vec3 startingPoint = new Vec3(this.m_20185_() - (double)bbRadius, this.m_20186_() - (double)bbRadius, this.m_20189_() - (double)bbRadius);
        Vec3 endingPoint = new Vec3(this.m_20185_() + (double)bbRadius, this.m_20186_() + (double)bbRadius, this.m_20189_() + (double)bbRadius);
        return new AABB(startingPoint, endingPoint);
    }

    public void m_141965_(ClientboundAddEntityPacket addEntityPacket) {
        super.m_141965_(addEntityPacket);
        this.m_20334_(addEntityPacket.m_131503_(), addEntityPacket.m_131504_(), addEntityPacket.m_131505_());
    }
}

