/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.block;

import com.alekiponi.alekiships.common.block.AbstractHullSideBlock;
import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.block.BoatFrame;
import com.alekiponi.alekiships.common.block.ProcessedBoatFrame;
import com.alekiponi.alekiships.common.block.ShipbuildingMultiblocks;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.alekiships.util.advancements.AlekiShipsAdvancements;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OarlockBlock
extends AbstractHullSideBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_SOUTH = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_WEST = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_EAST = Stream.of(Block.m_49796_((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    protected OarlockBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static Vec3 getSpawnPosition(Level pLevel, BlockPos thispos, BlockState blockState) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        thispos = thispos.m_7495_();
        BlockPos otherpos = thispos.m_121945_(direction.m_122424_());
        Vec3 origin = new Vec3((double)((float)(thispos.m_123341_() + otherpos.m_123341_()) / 2.0f + 0.5f), (double)((float)thispos.m_123342_() + 0.5f), (double)((float)(thispos.m_123343_() + otherpos.m_123343_()) / 2.0f + 0.5f));
        return origin;
    }

    public VoxelShape m_5940_(BlockState pstate, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pstate.m_61143_((Property)FACING);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP, Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            this.validateMultiblock(pLevel, pPos, pState);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void validateMultiblock(Level level, BlockPos thispos, BlockState blockState) {
        BlockState frameState = level.m_8055_(thispos.m_7495_());
        if (this.validateOarlocks(level, thispos, blockState) && this.validateFrames(level, thispos, blockState)) {
            Block block;
            Direction direction = (Direction)blockState.m_61143_((Property)FACING);
            Direction.Axis axis = direction.m_122427_().m_122434_();
            if (frameState.m_60734_() instanceof AngledBoatFrameBlock && (block = frameState.m_60734_()) instanceof ProcessedBoatFrame) {
                ProcessedBoatFrame boatFrameBlock = (ProcessedBoatFrame)block;
                boatFrameBlock.getBoatMaterial().getEntityType(BoatMaterial.BoatType.ROWBOAT).ifPresent(entityType -> {
                    AbstractVehicle rowboat = (AbstractVehicle)entityType.m_20615_(level);
                    if (rowboat != null) {
                        rowboat.m_146884_(OarlockBlock.getSpawnPosition(level, thispos, blockState));
                        if (axis == Direction.Axis.X) {
                            rowboat.m_146922_(90.0f);
                        }
                        level.m_7967_((Entity)rowboat);
                        for (ServerPlayer serverplayer : level.m_45976_(ServerPlayer.class, rowboat.m_20191_().m_82400_(5.0))) {
                            AlekiShipsAdvancements.ROWBOAT_COMPLETED.trigger(serverplayer);
                        }
                    }
                });
            }
        }
    }

    public boolean validateOarlocks(Level level, BlockPos thispos, BlockState blockState) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        if (level.m_8055_(thispos = thispos.m_121945_(direction.m_122424_())).m_60713_((Block)AlekiShipsBlocks.OARLOCK.get())) {
            return level.m_8055_(thispos).m_61143_((Property)FACING) == direction.m_122424_();
        }
        return false;
    }

    public boolean validateFrames(Level level, BlockPos thispos, BlockState blockState) {
        Direction structureDirection = ((Direction)blockState.m_61143_((Property)FACING)).m_122427_();
        Direction.Axis structureAxis = structureDirection.m_122434_();
        Direction crossDirection = structureDirection.m_122427_();
        thispos = thispos.m_7495_();
        BlockState frameState = level.m_8055_(thispos = thispos.m_121945_(structureDirection));
        BoatMaterial boatMaterial = BoatFrame.fromBlockstate(frameState);
        if (boatMaterial == null) {
            return false;
        }
        return ShipbuildingMultiblocks.validateShipHull(level, thispos, structureDirection, ShipbuildingMultiblocks.Multiblock.ROWBOAT, boatMaterial);
    }
}

