/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.block;

import com.alekiponi.alekiships.common.block.BoatFrame;
import java.util.IdentityHashMap;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AngledBoatFrameBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape[] SHAPES;
    private static final int[] SHAPE_BY_STATE;
    private final IdentityHashMap<Item, BoatFrame> boatFrames = new IdentityHashMap();

    public AngledBoatFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isInner(BlockState blockState) {
        return blockState.m_61143_(SHAPE) == StairsShape.INNER_LEFT || blockState.m_61143_(SHAPE) == StairsShape.INNER_RIGHT;
    }

    public static boolean isOuter(BlockState blockState) {
        return blockState.m_61143_(SHAPE) == StairsShape.OUTER_LEFT || blockState.m_61143_(SHAPE) == StairsShape.OUTER_RIGHT;
    }

    public static boolean isStraight(BlockState blockState) {
        return blockState.m_61143_(SHAPE) == StairsShape.STRAIGHT;
    }

    public static Direction[] getSolid(BlockState state) {
        ConstantShape shape = ConstantShape.getConstantShape(state);
        ConstantDirection directions = ConstantDirection.getConstantDirection(state);
        if (shape == ConstantShape.STRAIGHT) {
            return new Direction[]{(Direction)state.m_61143_((Property)FACING)};
        }
        if (shape == ConstantShape.INNER) {
            if (directions == ConstantDirection.NORTH_AND_EAST) {
                return new Direction[]{Direction.WEST, Direction.SOUTH};
            }
            if (directions == ConstantDirection.SOUTH_AND_EAST) {
                return new Direction[]{Direction.WEST, Direction.NORTH};
            }
            if (directions == ConstantDirection.NORTH_AND_WEST) {
                return new Direction[]{Direction.SOUTH, Direction.EAST};
            }
            if (directions == ConstantDirection.SOUTH_AND_WEST) {
                return new Direction[]{Direction.EAST, Direction.NORTH};
            }
        }
        return new Direction[0];
    }

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape northWestCorner, VoxelShape northEastCorner, VoxelShape southWestCorner, VoxelShape southEastCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(bitfield -> AngledBoatFrameBlock.makeStairShape(bitfield, slabShape, northWestCorner, northEastCorner, southWestCorner, southEastCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int bitfield, VoxelShape slabShape, VoxelShape northWestCorner, VoxelShape northEastCorner, VoxelShape southWestCorner, VoxelShape southEastCorner) {
        VoxelShape northWestCornerOpposite = northWestCorner.m_83216_(0.0, -0.5, 0.0);
        VoxelShape northEastCornerOpposite = northEastCorner.m_83216_(0.0, -0.5, 0.0);
        VoxelShape southWestCornerOpposite = southWestCorner.m_83216_(0.0, -0.5, 0.0);
        VoxelShape southEastCornerOpposite = southEastCorner.m_83216_(0.0, -0.5, 0.0);
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)slabShape, (VoxelShape)northWestCorner);
            voxelshape = Shapes.m_83113_((VoxelShape)voxelshape, (VoxelShape)northWestCornerOpposite, (BooleanOp)BooleanOp.f_82685_);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)northEastCorner);
            voxelshape = Shapes.m_83113_((VoxelShape)voxelshape, (VoxelShape)northEastCornerOpposite, (BooleanOp)BooleanOp.f_82685_);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)southWestCorner);
            voxelshape = Shapes.m_83113_((VoxelShape)voxelshape, (VoxelShape)southWestCornerOpposite, (BooleanOp)BooleanOp.f_82685_);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)southEastCorner);
            voxelshape = Shapes.m_83113_((VoxelShape)voxelshape, (VoxelShape)southEastCornerOpposite, (BooleanOp)BooleanOp.f_82685_);
        }
        return voxelshape;
    }

    protected static StairsShape getStairsShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        Direction neighborFacing;
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        BlockState neighborBlockState = blockGetter.m_8055_(blockPos.m_121945_(direction));
        if (AngledBoatFrameBlock.isAngledBoatFrame(neighborBlockState) && (neighborFacing = (Direction)neighborBlockState.m_61143_((Property)FACING)).m_122434_() != ((Direction)blockState.m_61143_((Property)FACING)).m_122434_() && AngledBoatFrameBlock.canTakeShape(blockState, blockGetter, blockPos, neighborFacing.m_122424_())) {
            if (neighborFacing == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        neighborBlockState = blockGetter.m_8055_(blockPos.m_121945_(direction.m_122424_()));
        if (AngledBoatFrameBlock.isAngledBoatFrame(neighborBlockState) && (neighborFacing = (Direction)neighborBlockState.m_61143_((Property)FACING)).m_122434_() != ((Direction)blockState.m_61143_((Property)FACING)).m_122434_() && AngledBoatFrameBlock.canTakeShape(blockState, blockGetter, blockPos, neighborFacing)) {
            if (neighborFacing == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        BlockState blockstate = blockGetter.m_8055_(blockPos.m_121945_(direction));
        return !AngledBoatFrameBlock.isAngledBoatFrame(blockstate) || blockstate.m_61143_((Property)FACING) != blockState.m_61143_((Property)FACING);
    }

    public static boolean isAngledBoatFrame(BlockState blockState) {
        return blockState.m_60734_() instanceof AngledBoatFrameBlock;
    }

    public final void registerFrame(Item item, BoatFrame boatFrame) {
        assert (boatFrame instanceof Block) : "Registered Frames must be implemented on a Block";
        this.boatFrames.put(item, boatFrame);
    }

    @Nullable
    protected BoatFrame getFrame(Item item) {
        return this.boatFrames.get(item);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldStack = player.m_21120_(hand);
        BoatFrame frameBlock = this.getFrame(heldStack.m_41720_());
        if (frameBlock == null) {
            return InteractionResult.PASS;
        }
        BlockState frameBlockstate = frameBlock.m_152465_(blockState);
        level.m_46597_(blockPos, frameBlockstate);
        if (!player.m_150110_().f_35937_) {
            heldStack.m_41774_(1);
        }
        SoundType soundType = frameBlockstate.getSoundType((LevelReader)level, blockPos, (Entity)player);
        level.m_5594_(player, blockPos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        return InteractionResult.SUCCESS;
    }

    public boolean m_7923_(BlockState blockState) {
        return true;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return SHAPES[SHAPE_BY_STATE[this.getShapeIndex(blockState)]];
    }

    private int getShapeIndex(BlockState blockState) {
        return ((StairsShape)blockState.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)blockState.m_61143_((Property)FACING)).m_122416_();
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        BlockPos blockpos = placeContext.m_8083_();
        FluidState fluidstate = placeContext.m_43725_().m_6425_(blockpos);
        BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeContext.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockstate.m_61124_(SHAPE, (Comparable)AngledBoatFrameBlock.getStairsShape(blockstate, (BlockGetter)placeContext.m_43725_(), blockpos));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos neighborPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (direction.m_122434_().m_122479_()) {
            return (BlockState)blockState.m_61124_(SHAPE, (Comparable)AngledBoatFrameBlock.getStairsShape(blockState, (BlockGetter)levelAccessor, blockPos));
        }
        return super.m_7417_(blockState, direction, neighborState, levelAccessor, blockPos, neighborPos);
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)blockState.m_61143_(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                return switch (stairsshape) {
                    case StairsShape.INNER_LEFT -> (BlockState)blockState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)blockState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)blockState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)blockState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> blockState.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                return switch (stairsshape) {
                    default -> throw new IncompatibleClassChangeError();
                    case StairsShape.INNER_LEFT -> (BlockState)blockState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)blockState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)blockState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)blockState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> blockState.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.m_6943_(blockState, mirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType computationType) {
        return false;
    }

    static {
        SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
        VoxelShape bottom = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape northWest = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
        VoxelShape northEast = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        VoxelShape southWest = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
        VoxelShape southEast = Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
        SHAPES = AngledBoatFrameBlock.makeShapes(bottom, northWest, northEast, southWest, southEast);
    }

    public static enum ConstantShape {
        STRAIGHT,
        INNER,
        OUTER;


        public static ConstantShape getConstantShape(BlockState blockState) {
            if (AngledBoatFrameBlock.isInner(blockState)) {
                return INNER;
            }
            if (AngledBoatFrameBlock.isOuter(blockState)) {
                return OUTER;
            }
            return STRAIGHT;
        }
    }

    public static enum ConstantDirection {
        NORTH_AND_EAST,
        NORTH_AND_WEST,
        SOUTH_AND_EAST,
        SOUTH_AND_WEST,
        NORTH_AND_SOUTH,
        EAST_AND_WEST;


        @Nullable
        public static ConstantDirection getConstantDirection(BlockState blockState) {
            if (!(blockState.m_60734_() instanceof AngledBoatFrameBlock)) {
                return null;
            }
            return switch ((Direction)blockState.m_61143_((Property)FACING)) {
                case Direction.SOUTH -> {
                    switch ((StairsShape)blockState.m_61143_(SHAPE)) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case STRAIGHT: {
                            yield EAST_AND_WEST;
                        }
                        case INNER_RIGHT: {
                            yield NORTH_AND_EAST;
                        }
                        case INNER_LEFT: {
                            yield NORTH_AND_WEST;
                        }
                        case OUTER_RIGHT: {
                            yield SOUTH_AND_WEST;
                        }
                        case OUTER_LEFT: 
                    }
                    yield SOUTH_AND_EAST;
                }
                case Direction.NORTH -> {
                    switch ((StairsShape)blockState.m_61143_(SHAPE)) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case STRAIGHT: {
                            yield EAST_AND_WEST;
                        }
                        case INNER_RIGHT: {
                            yield SOUTH_AND_WEST;
                        }
                        case INNER_LEFT: {
                            yield SOUTH_AND_EAST;
                        }
                        case OUTER_RIGHT: {
                            yield NORTH_AND_EAST;
                        }
                        case OUTER_LEFT: 
                    }
                    yield NORTH_AND_WEST;
                }
                case Direction.EAST -> {
                    switch ((StairsShape)blockState.m_61143_(SHAPE)) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case STRAIGHT: {
                            yield NORTH_AND_SOUTH;
                        }
                        case INNER_RIGHT: {
                            yield NORTH_AND_WEST;
                        }
                        case INNER_LEFT: {
                            yield SOUTH_AND_WEST;
                        }
                        case OUTER_RIGHT: {
                            yield SOUTH_AND_EAST;
                        }
                        case OUTER_LEFT: 
                    }
                    yield NORTH_AND_EAST;
                }
                case Direction.WEST -> {
                    switch ((StairsShape)blockState.m_61143_(SHAPE)) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case STRAIGHT: {
                            yield NORTH_AND_SOUTH;
                        }
                        case INNER_RIGHT: {
                            yield SOUTH_AND_EAST;
                        }
                        case INNER_LEFT: {
                            yield NORTH_AND_EAST;
                        }
                        case OUTER_RIGHT: {
                            yield NORTH_AND_WEST;
                        }
                        case OUTER_LEFT: 
                    }
                    yield SOUTH_AND_WEST;
                }
                default -> null;
            };
        }

        @Nullable
        public static ConstantDirection rotateConstantDirection(ConstantDirection constantDirection, Direction direction) {
            return switch (direction) {
                case Direction.NORTH -> constantDirection;
                case Direction.SOUTH -> {
                    switch (constantDirection) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NORTH_AND_SOUTH: 
                        case EAST_AND_WEST: {
                            yield constantDirection;
                        }
                        case NORTH_AND_EAST: {
                            yield SOUTH_AND_WEST;
                        }
                        case NORTH_AND_WEST: {
                            yield SOUTH_AND_EAST;
                        }
                        case SOUTH_AND_EAST: {
                            yield NORTH_AND_WEST;
                        }
                        case SOUTH_AND_WEST: 
                    }
                    yield NORTH_AND_EAST;
                }
                case Direction.EAST -> {
                    switch (constantDirection) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NORTH_AND_SOUTH: {
                            yield EAST_AND_WEST;
                        }
                        case EAST_AND_WEST: {
                            yield NORTH_AND_SOUTH;
                        }
                        case NORTH_AND_EAST: {
                            yield SOUTH_AND_EAST;
                        }
                        case NORTH_AND_WEST: {
                            yield NORTH_AND_EAST;
                        }
                        case SOUTH_AND_EAST: {
                            yield SOUTH_AND_WEST;
                        }
                        case SOUTH_AND_WEST: 
                    }
                    yield NORTH_AND_WEST;
                }
                case Direction.WEST -> {
                    switch (constantDirection) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NORTH_AND_SOUTH: {
                            yield EAST_AND_WEST;
                        }
                        case EAST_AND_WEST: {
                            yield NORTH_AND_SOUTH;
                        }
                        case NORTH_AND_EAST: {
                            yield NORTH_AND_WEST;
                        }
                        case NORTH_AND_WEST: {
                            yield SOUTH_AND_WEST;
                        }
                        case SOUTH_AND_EAST: {
                            yield NORTH_AND_EAST;
                        }
                        case SOUTH_AND_WEST: 
                    }
                    yield SOUTH_AND_EAST;
                }
                default -> null;
            };
        }
    }
}

