/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import mekanism.api.IEvaporationSolar;
import mekanism.api.RelativeSide;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityAdvancedSolarGenerator
extends TileEntitySolarGenerator
implements IBoundingBlock,
IEvaporationSolar {
    private final TileEntitySolarGenerator.SolarCheck[] solarChecks = new TileEntitySolarGenerator.SolarCheck[8];

    public TileEntityAdvancedSolarGenerator(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.ADVANCED_SOLAR_GENERATOR, pos, state, (FloatingLongSupplier)MekanismGeneratorsConfig.generators.advancedSolarGeneration);
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.EVAPORATION_SOLAR, (Object)((Object)this)));
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.FRONT, RelativeSide.BOTTOM};
    }

    @Override
    protected FloatingLong getConfiguredMax() {
        return (FloatingLong)MekanismGeneratorsConfig.generators.advancedSolarGeneration.get();
    }

    @Override
    protected void recheckSettings() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos topPos = this.f_58858_.m_6630_(2);
        this.solarCheck = new AdvancedSolarCheck(this.f_58857_, topPos);
        float totalPeak = this.solarCheck.getPeakMultiplier();
        for (int i = 0; i < this.solarChecks.length; ++i) {
            this.solarChecks[i] = i < 3 ? new AdvancedSolarCheck(this.f_58857_, topPos.m_7918_(-1, 0, i - 1)) : (i == 3 ? new AdvancedSolarCheck(this.f_58857_, topPos.m_7918_(0, 0, -1)) : (i == 4 ? new AdvancedSolarCheck(this.f_58857_, topPos.m_7918_(0, 0, 1)) : new AdvancedSolarCheck(this.f_58857_, topPos.m_7918_(1, 0, i - 6))));
            totalPeak += this.solarChecks[i].getPeakMultiplier();
        }
        this.updateMaxOutputRaw(this.getConfiguredMax().multiply((double)(totalPeak / 9.0f)));
    }

    @Override
    protected boolean checkCanSeeSun() {
        if (this.solarCheck == null) {
            return false;
        }
        this.solarCheck.recheckCanSeeSun();
        int count = this.solarCheck.canSeeSun() ? 1 : 0;
        for (TileEntitySolarGenerator.SolarCheck check : this.solarChecks) {
            check.recheckCanSeeSun();
            if (!check.canSeeSun()) continue;
            count = (byte)(count + 1);
        }
        return count > 4;
    }

    @Override
    public FloatingLong getProduction() {
        if (this.f_58857_ == null || this.solarCheck == null) {
            return FloatingLong.ZERO;
        }
        float brightness = this.getBrightnessMultiplier(this.f_58857_);
        float generationMultiplier = this.solarCheck.getGenerationMultiplier();
        for (TileEntitySolarGenerator.SolarCheck check : this.solarChecks) {
            generationMultiplier += check.getGenerationMultiplier();
        }
        return this.getConfiguredMax().multiply((double)(brightness * (generationMultiplier /= (float)(this.solarChecks.length + 1))));
    }

    private static class AdvancedSolarCheck
    extends TileEntitySolarGenerator.SolarCheck {
        private final int recheckFrequency;
        private long lastCheckedSun;

        public AdvancedSolarCheck(Level world, BlockPos pos) {
            super(world, pos);
            this.recheckFrequency = Mth.m_216271_((RandomSource)world.f_46441_, (int)10, (int)30);
        }

        @Override
        public void recheckCanSeeSun() {
            BlockState state;
            BlockPos above;
            if (!this.world.m_6042_().f_223549_() || this.world.m_7445_() >= 4) {
                this.canSeeSun = false;
                return;
            }
            long time = this.world.m_46467_();
            if (time < this.lastCheckedSun + (long)this.recheckFrequency) {
                return;
            }
            this.lastCheckedSun = time;
            this.canSeeSun = this.world.m_6425_(this.pos).m_76178_() ? this.world.m_45527_(this.pos) : (this.world.m_45527_(above = this.pos.m_7494_()) ? !(state = this.world.m_8055_(above)).m_278721_() && state.m_60739_((BlockGetter)this.world, above) <= 0 : false);
        }
    }
}

