/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.item;

import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.RateLimitGasHandler;
import mekanism.common.config.value.CachedLongValue;
import mekanism.common.item.CapabilityItem;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.StorageUtils;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsGases;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemHohlraum
extends CapabilityItem
implements CreativeTabDeferredRegister.ICustomCreativeTabContents {
    public ItemHohlraum(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        GasStack storedGas;
        IGasHandler gasHandlerItem;
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER).resolve();
        if (capability.isPresent() && (gasHandlerItem = (IGasHandler)capability.get()).getTanks() > 0 && !(storedGas = (GasStack)gasHandlerItem.getChemicalInTank(0)).isEmpty()) {
            tooltip.add((Component)MekanismLang.STORED.translate(new Object[]{storedGas, storedGas.getAmount()}));
            if (storedGas.getAmount() == gasHandlerItem.getTankCapacity(0)) {
                tooltip.add((Component)GeneratorsLang.READY_FOR_REACTION.translateColored(EnumColor.DARK_GREEN, new Object[0]));
            } else {
                tooltip.add((Component)GeneratorsLang.INSUFFICIENT_FUEL.translateColored(EnumColor.DARK_RED, new Object[0]));
            }
            return;
        }
        tooltip.add((Component)MekanismLang.NO_GAS.translate(new Object[0]));
        tooltip.add((Component)GeneratorsLang.INSUFFICIENT_FUEL.translateColored(EnumColor.DARK_RED, new Object[0]));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return StorageUtils.getBarWidth((ItemStack)stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return ChemicalUtil.getRGBDurabilityForDisplay((ItemStack)stack);
    }

    public void addItems(CreativeModeTab.Output tabOutput) {
        tabOutput.m_246342_(ChemicalUtil.getFilledVariant((ItemStack)new ItemStack((ItemLike)this), (CachedLongValue)MekanismGeneratorsConfig.generators.hohlraumMaxGas, GeneratorsGases.FUSION_FUEL));
    }

    protected boolean areCapabilityConfigsLoaded() {
        return super.areCapabilityConfigsLoaded() && MekanismGeneratorsConfig.generators.isLoaded();
    }

    protected void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack, CompoundTag nbt) {
        super.gatherCapabilities(capabilities, stack, nbt);
        capabilities.add((ItemCapabilityWrapper.ItemCapability)RateLimitGasHandler.create((LongSupplier)MekanismGeneratorsConfig.generators.hohlraumFillRate, (LongSupplier)MekanismGeneratorsConfig.generators.hohlraumMaxGas, (BiPredicate)ChemicalTankBuilder.GAS.notExternal, (BiPredicate)ChemicalTankBuilder.GAS.alwaysTrueBi, arg_0 -> GeneratorTags.Gases.FUSION_FUEL_LOOKUP.contains(arg_0)));
    }
}

