/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks;

import earth.terrarium.handcrafted.common.blocks.base.SittableBlock;
import earth.terrarium.handcrafted.common.blocks.base.properties.DirectionalBlockProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DiningBenchBlock
extends HorizontalDirectionalBlock
implements SittableBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<DirectionalBlockProperty> SHAPE = EnumProperty.m_61587_((String)"shape", DirectionalBlockProperty.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape X_AXIS_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)9.0, (double)16.0);
    public static final VoxelShape Z_AXIS_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)9.0, (double)13.0);
    public static final AABB SEAT = new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public DiningBenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)DirectionalBlockProperty.SINGLE))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, f_54117_, WATERLOGGED});
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.sitOn(level, pos, player, null)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME_PARTIAL;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X ? X_AXIS_SHAPE : Z_AXIS_SHAPE;
    }

    @Override
    public AABB getSeatSize(BlockState state) {
        return SEAT;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)DiningBenchBlock.getShape((Block)this, (Direction)state.m_61143_((Property)f_54117_), (BlockGetter)level, currentPos))) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)DiningBenchBlock.getShape((Block)this, (Direction)state.m_61143_((Property)f_54117_), (BlockGetter)context.m_43725_(), pos)));
    }

    public static DirectionalBlockProperty getShape(Block block, Direction direction, BlockGetter level, BlockPos pos) {
        boolean check2;
        BlockState state1 = level.m_8055_(pos.m_121945_(direction.m_122427_().m_122424_()));
        BlockState state2 = level.m_8055_(pos.m_121945_(direction.m_122427_()));
        boolean check1 = state1.m_60713_(block) && state1.m_61143_((Property)f_54117_) != direction;
        boolean bl = check2 = state2.m_60713_(block) && state2.m_61143_((Property)f_54117_) != direction;
        if (!state1.m_60713_(block) && !state2.m_60713_(block)) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (check1 && state2.m_60713_(block)) {
            return DirectionalBlockProperty.RIGHT;
        }
        if (check2 && state1.m_60713_(block)) {
            return DirectionalBlockProperty.LEFT;
        }
        if (check1) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (check2) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (!state1.m_60713_(block)) {
            return DirectionalBlockProperty.RIGHT;
        }
        if (!state2.m_60713_(block)) {
            return DirectionalBlockProperty.LEFT;
        }
        return DirectionalBlockProperty.MIDDLE;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

