/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.knightsnmages.registry;

import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.veroxuniverse.knightsnmages.block.EliteMageBloomCrop;
import net.veroxuniverse.knightsnmages.block.NobleMageBloomCrop;
import net.veroxuniverse.knightsnmages.registry.ItemsRegistry;

public class BlocksRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"knightsnmages");
    public static final RegistryObject<Block> ELITE_MAGEBLOOM_CROP = BlocksRegistry.registerBlockWithoutBlockItem("elite_magebloom_crop", () -> new EliteMageBloomCrop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60910_().m_60955_()));
    public static final RegistryObject<Block> ELITE_SOURCE_GEM_BLOCK = BlocksRegistry.registerBlock("elite_source_gem_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BlockRegistry.SOURCE_GEM_BLOCK.get())).m_60978_(4.0f).m_60999_().m_60955_()));
    public static final RegistryObject<Block> NOBLE_MAGEBLOOM_CROP = BlocksRegistry.registerBlockWithoutBlockItem("noble_magebloom_crop", () -> new NobleMageBloomCrop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60910_().m_60955_()));
    public static final RegistryObject<Block> NOBLE_SOURCE_GEM_BLOCK = BlocksRegistry.registerBlock("noble_source_gem_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BlockRegistry.SOURCE_GEM_BLOCK.get())).m_60978_(4.0f).m_60999_().m_60955_()));
    public static final RegistryObject<Block> SCARLET_BLOCK = BlocksRegistry.registerBlock("scarlet_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> CITRIN_BLOCK = BlocksRegistry.registerBlock("citrin_block", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> MOONLIGHT_BLOCK = BlocksRegistry.registerBlock("moonlight_block", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> SCARLET_ORE = BlocksRegistry.registerBlock("scarlet_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> CITRIN_ORE = BlocksRegistry.registerBlock("citrin_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> MOONLIGHT_ORE = BlocksRegistry.registerBlock("moonlight_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> DEEPSLATE_SCARLET_ORE = BlocksRegistry.registerBlock("deepslate_scarlet_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> DEEPSLATE_CITRIN_ORE = BlocksRegistry.registerBlock("deepslate_citrin_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> DEEPSLATE_MOONLIGHT_ORE = BlocksRegistry.registerBlock("deepslate_moonlight_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlocksRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ItemsRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

