/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.knightsnmages.item.armor.custom.allthemodium;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.veroxuniverse.knightsnmages.compat.ATMCompat;
import net.veroxuniverse.knightsnmages.item.armor.KNMArmorItem;
import net.veroxuniverse.knightsnmages.item.armor.client.renderer.UnobtainiumRenderer;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.model.GeoModel;

public class Unobtainium
extends KNMArmorItem {
    public Unobtainium(ArmorMaterial materialIn, ArmorItem.Type slot, Item.Properties builder, GeoModel<AnimatedMagicArmor> model) {
        super(materialIn, slot, builder, model);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private UnobtainiumRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new UnobtainiumRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> {
            state.setAnimation(RawAnimation.begin().then("animation.mage.idle", Animation.LoopType.LOOP));
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            if (entity instanceof ArmorStand) {
                return PlayState.CONTINUE;
            }
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (ItemStack stack : entity.m_6168_()) {
                if (stack.m_41619_()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.m_41720_());
            }
            boolean isFullSet = wornArmor.containsAll((Collection<?>)ObjectArrayList.of((Object[])new Item[]{(Item)ATMCompat.MAGE_UNOBTAINIUM_HELMET.get(), (Item)ATMCompat.MAGE_UNOBTAINIUM_CHESTPLATE.get(), (Item)ATMCompat.MAGE_UNOBTAINIUM_LEGGINGS.get(), (Item)ATMCompat.MAGE_UNOBTAINIUM_BOOTS.get()}));
            return isFullSet ? PlayState.CONTINUE : PlayState.STOP;
        })});
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        ImmutableMultimap.Builder attributes = new ImmutableMultimap.Builder();
        attributes.putAll(super.m_7167_(pEquipmentSlot));
        if (this.f_265916_.m_266308_() == pEquipmentSlot) {
            UUID uuid = (UUID)f_265987_.get(this.f_265916_);
            IPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)stack);
            if (perkHolder != null) {
                attributes.put((Object)((Attribute)PerkAttributes.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "max_mana_armor", (double)(100 * (perkHolder.getTier() + 1)), AttributeModifier.Operation.ADDITION));
                attributes.put((Object)((Attribute)PerkAttributes.MANA_REGEN_BONUS.get()), (Object)new AttributeModifier(uuid, "mana_regen_armor", (double)(perkHolder.getTier() + 3), AttributeModifier.Operation.ADDITION));
                for (PerkInstance perkInstance : perkHolder.getPerkInstances()) {
                    IPerk perk = perkInstance.getPerk();
                    attributes.putAll(perk.getModifiers(this.f_265916_.m_266308_(), stack, perkInstance.getSlot().value));
                }
            }
        }
        return attributes.build();
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return new ResourceLocation("knightsnmages", "textures/armor/mage_unobtainium.png").toString();
    }
}

