/*
 * Decompiled with CFR 0.152.
 */
package com.zhichaoxi.applied_schematicannon.mixin;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.blockentity.misc.InterfaceBlockEntity;
import com.simibubi.create.content.schematics.cannon.MaterialChecklist;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.content.schematics.cannon.SchematicannonInventory;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.Set;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SchematicannonBlockEntity.class}, remap=false)
public abstract class SchematicannonBlockEntityMixin
extends BlockEntity {
    @Shadow
    public boolean hasCreativeCrate;
    @Shadow
    public int remainingFuel;
    @Shadow
    public boolean sendUpdate;
    @Shadow
    public SchematicannonInventory inventory;
    @Shadow
    public String statusMsg;
    @Shadow
    public int blocksPlaced;
    @Shadow
    public SchematicannonBlockEntity.State state;
    @Shadow
    public MaterialChecklist checklist;
    @Unique
    protected ArrayList<IGridNode> SchematicannonBlockEntityMixin$attachedMENetwork = new ArrayList();

    @Shadow
    protected abstract void refillFuelIfPossible();

    @Shadow
    public abstract int getShotsPerGunpowder();

    @Shadow
    public abstract void findInventories();

    public SchematicannonBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Inject(method={"updateChecklist"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/schematics/cannon/SchematicannonBlockEntity;findInventories()V")})
    public void SchematicannonBlockEntityMixin$updateChecklist(CallbackInfo ci) {
        this.findInventories();
        for (IGridNode cap : this.SchematicannonBlockEntityMixin$attachedMENetwork) {
            if (cap == null) continue;
            MEStorage storage = cap.getGrid().getStorageService().getInventory();
            Set set = storage.getAvailableStacks().keySet();
            for (AEKey key : set) {
                long amount;
                ItemStack stack;
                if (!(key instanceof AEItemKey) || (stack = ((AEItemKey)key).toStack((int)(amount = storage.extract(key, Long.MAX_VALUE, Actionable.SIMULATE, null)))).m_41619_()) continue;
                this.checklist.collect(stack);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/schematics/cannon/SchematicannonBlockEntity;refillFuelIfPossible()V")})
    public void tick$refillFromMENetwork(CallbackInfo ci) {
        this.refillFuelIfPossible();
        this.SchematicannonBlockEntityMixin$refillFuelIfPossible();
    }

    @Unique
    protected void SchematicannonBlockEntityMixin$refillFuelIfPossible() {
        if (this.hasCreativeCrate) {
            return;
        }
        if (this.remainingFuel > this.getShotsPerGunpowder()) {
            this.remainingFuel = this.getShotsPerGunpowder();
            this.sendUpdate = true;
            return;
        }
        if (this.remainingFuel > 0) {
            return;
        }
        if (!this.inventory.getStackInSlot(4).m_41619_()) {
            this.inventory.getStackInSlot(4).m_41774_(1);
        } else {
            boolean externalGunpowderFound = false;
            for (IGridNode cap : this.SchematicannonBlockEntityMixin$attachedMENetwork) {
                MEStorage storage = cap.getGrid().getStorageService().getInventory();
                if (storage.extract((AEKey)AEItemKey.of((ItemLike)Items.f_42403_), 1L, Actionable.MODULATE, null) == 0L) continue;
                externalGunpowderFound = true;
                break;
            }
            if (!externalGunpowderFound) {
                return;
            }
        }
        this.remainingFuel += this.getShotsPerGunpowder();
        if (this.statusMsg.equals("noGunpowder")) {
            if (this.blocksPlaced > 0) {
                this.state = SchematicannonBlockEntity.State.RUNNING;
            }
            this.statusMsg = "ready";
        }
        this.sendUpdate = true;
    }

    @Inject(method={"findInventories"}, at={@At(value="RETURN")})
    public void findInventories$findMENetwork(CallbackInfo ci) {
        this.SchematicannonBlockEntityMixin$attachedMENetwork.clear();
        for (Direction facing : Iterate.directions) {
            IGridNode GridNode;
            if (this.f_58857_ != null && !this.f_58857_.m_46749_(this.f_58858_.m_121945_(facing))) continue;
            BlockEntity blockEntity = null;
            if (this.f_58857_ != null) {
                blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
            }
            if (!(blockEntity instanceof InterfaceBlockEntity) || (GridNode = ((InterfaceBlockEntity)blockEntity).getInterfaceLogic().getActionableNode()) == null) continue;
            this.SchematicannonBlockEntityMixin$attachedMENetwork.add(GridNode);
        }
    }

    @Inject(method={"grabItemsFromAttachedInventories"}, at={@At(value="TAIL")}, cancellable=true)
    public void SchematicannonBlockEntityMixin$grabFromMENetwork(ItemRequirement.StackRequirement required, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        MEStorage storage;
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        ItemRequirement.ItemUseType usage = required.usage;
        if (usage == ItemRequirement.ItemUseType.DAMAGE) {
            for (IGridNode cap : this.SchematicannonBlockEntityMixin$attachedMENetwork) {
                if (cap == null) continue;
                MEStorage storage2 = cap.getGrid().getStorageService().getInventory();
                Set set = storage2.getAvailableStacks().keySet();
                for (AEKey key : set) {
                    ItemStack extractItem;
                    if (!(key instanceof AEItemKey) || !required.matches(extractItem = ((AEItemKey)key).toStack()) || !extractItem.m_41763_()) continue;
                    if (!simulate) {
                        long amount = storage2.extract(key, 1L, Actionable.MODULATE, null);
                        ItemStack stack = new ItemStack((ItemLike)((AEItemKey)key).getItem(), (int)amount);
                        stack.m_41721_(stack.m_41773_() + 1);
                        if (stack.m_41773_() <= stack.m_41776_()) {
                            storage2.insert((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.m_41613_(), Actionable.MODULATE, null);
                        }
                    }
                    cir.setReturnValue((Object)true);
                }
            }
            cir.setReturnValue((Object)false);
        }
        boolean success = false;
        long amountFound = 0L;
        for (IGridNode cap : this.SchematicannonBlockEntityMixin$attachedMENetwork) {
            if (cap != null) {
                storage = cap.getGrid().getStorageService().getInventory();
                amountFound += storage.extract((AEKey)AEItemKey.of((ItemStack)required.stack), (long)required.stack.m_41613_(), Actionable.SIMULATE, null);
            }
            if (amountFound < (long)required.stack.m_41613_()) continue;
            success = true;
            break;
        }
        if (!simulate && success) {
            amountFound = 0L;
            for (IGridNode cap : this.SchematicannonBlockEntityMixin$attachedMENetwork) {
                if (cap != null) {
                    storage = cap.getGrid().getStorageService().getInventory();
                    amountFound += storage.extract((AEKey)AEItemKey.of((ItemStack)required.stack), (long)required.stack.m_41613_(), Actionable.MODULATE, null);
                }
                if (amountFound < (long)required.stack.m_41613_()) continue;
            }
        }
        cir.setReturnValue((Object)success);
    }
}

