/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.spell;

import alexthw.not_enough_glyphs.common.spell.BookPerk;
import com.hollingsworth.arsnouveau.api.perk.IEffectResolvePerk;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class RandomPerk
extends BookPerk
implements IEffectResolvePerk {
    public static final RandomPerk INSTANCE = new RandomPerk(new ResourceLocation("ars_nouveau", "thread_wild_magic"));
    public static final Random random = new Random();

    public RandomPerk(ResourceLocation key) {
        super(key);
    }

    public static SpellStats.Builder applyItemModifiers(SpellStats.Builder builder, Level world) {
        if (random.nextFloat() <= 0.5f) {
            WILD_MAGIC randomEffect = WILD_MAGIC.values()[random.nextInt(WILD_MAGIC.values().length)];
            randomEffect.apply(builder);
        }
        return builder;
    }

    public static enum WILD_MAGIC {
        AREA(stats -> stats.addAOE(random.nextBoolean() ? 1.0 : -1.0)),
        DURATION(stats -> stats.addDurationModifier(random.nextBoolean() ? 1.0 : -1.0)),
        MISC(stats -> {
            switch (random.nextInt(4)) {
                case 0: {
                    stats.addAugment((AbstractAugment)AugmentSplit.INSTANCE);
                    break;
                }
                case 1: {
                    stats.addAugment((AbstractAugment)AugmentPierce.INSTANCE);
                    break;
                }
                case 2: {
                    stats.randomize();
                    break;
                }
                default: {
                    stats.setSensitive();
                }
            }
        }),
        POWER(stats -> stats.addDamageModifier(random.nextBoolean() ? 1.0 : -1.0)),
        VELOCITY(stats -> stats.addAccelerationModifier(random.nextBoolean() ? 1.0f : -1.0f));

        private final Consumer<SpellStats.Builder> transform;

        private WILD_MAGIC(Consumer<SpellStats.Builder> transform) {
            this.transform = transform;
        }

        public void apply(SpellStats.Builder stats) {
            this.transform.accept(stats);
        }
    }
}

