/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.propagators;

import alexthw.not_enough_glyphs.api.IPropagator;
import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.common.glyphs.MethodArc;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropagateArc
extends AbstractEffect
implements IPropagator {
    public static final PropagateArc INSTANCE = new PropagateArc();

    public PropagateArc() {
        super(CompatRL.elemental("propagator_arc"), "Propagate Arc");
    }

    public Integer getTypeIndex() {
        return 8;
    }

    @Override
    public void propagate(Level world, HitResult hitResult, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        Vec3 pos = hitResult.m_82450_();
        ArrayList<EntityProjectileSpell> projectiles = new ArrayList<EntityProjectileSpell>();
        EntityProjectileSpell projectileSpell = new EntityProjectileSpell(world, resolver).setGravity(true);
        projectileSpell.m_146884_(pos.m_82520_(0.0, 1.0, 0.0));
        projectiles.add(projectileSpell);
        int numSplits = stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        float sizeRatio = shooter.m_20192_() / 1.62f;
        for (int i = 1; i < numSplits + 1; ++i) {
            Direction offset = shooter.m_6350_().m_122427_();
            if (i % 2 == 0) {
                offset = offset.m_122424_();
            }
            BlockPos projPos = BlockPos.m_274446_((Position)pos).m_5484_(offset, i).m_7918_(0, (int)(1.5 * (double)sizeRatio), 0);
            EntityProjectileSpell entityProjectileSpell = new EntityProjectileSpell(world, resolver).setGravity(true);
            entityProjectileSpell.m_6034_((double)projPos.m_123341_(), (double)projPos.m_123342_(), (double)projPos.m_123343_());
            projectiles.add(entityProjectileSpell);
        }
        float velocity = MethodArc.getProjectileSpeed(stats);
        Vec3 direction = pos.m_82546_(shooter.m_20182_());
        IWrappedCaster iWrappedCaster = resolver.spellContext.getCaster();
        if (iWrappedCaster instanceof TileCaster) {
            TileCaster tc = (TileCaster)iWrappedCaster;
            BlockEntity blockEntity = tc.getTile();
            if (blockEntity instanceof RotatingTurretTile) {
                RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                direction = rotatingTurretTile.getShootAngle();
            } else {
                direction = new Vec3(((Direction)tc.getTile().m_58900_().m_61143_((Property)BasicSpellTurret.FACING)).m_253071_());
            }
        }
        for (EntityProjectileSpell entityProjectileSpell : projectiles) {
            entityProjectileSpell.m_146884_(entityProjectileSpell.m_20182_().m_82520_(0.0, 0.25 * (double)sizeRatio, 0.0));
            if (!(shooter instanceof FakePlayer)) {
                entityProjectileSpell.shoot((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 0.3f);
            } else {
                entityProjectileSpell.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, 0.8f);
            }
            world.m_7967_((Entity)entityProjectileSpell);
        }
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public int getDefaultManaCost() {
        return 200;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return MethodArc.INSTANCE.getCompatibleAugments();
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }
}

