/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.common.spell.TrailingProjectile;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDecelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBurst;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWall;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class MethodTrail
extends AbstractCastMethod {
    public static final MethodTrail INSTANCE = new MethodTrail();
    public ForgeConfigSpec.IntValue PROJECTILE_TTL;

    public MethodTrail() {
        super(CompatRL.neg("trail"), "Trail");
    }

    protected void addDefaultInvalidCombos(Set<ResourceLocation> defaults) {
        defaults.addAll(Stream.of(EffectLinger.INSTANCE, EffectWall.INSTANCE, EffectBurst.INSTANCE).map(AbstractSpellPart::getRegistryName).toList());
    }

    public void summonProjectiles(Level world, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        int numSplits = 1 + stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        ArrayList<TrailingProjectile> projectiles = new ArrayList<TrailingProjectile>();
        for (int i = 0; i < numSplits; ++i) {
            TrailingProjectile spell = new TrailingProjectile(world, resolver);
            spell.setAoe(stats.getAoeMultiplier());
            spell.setDelay((int)stats.getDurationMultiplier());
            projectiles.add(spell);
        }
        float velocity = Math.max(0.1f, 0.75f + stats.getAccMultiplier() / 2.0f);
        int opposite = -1;
        int counter = 0;
        for (TrailingProjectile proj : projectiles) {
            proj.shoot((Entity)shooter, shooter.m_146909_(), shooter.m_146908_() + (float)(Math.round((double)counter / 2.0) * 10L * (long)opposite), 0.0f, velocity, 0.8f);
            opposite *= -1;
            ++counter;
            world.m_7967_((Entity)proj);
        }
    }

    public void summonProjectiles(Level world, BlockPos pos, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        ArrayList<EntityProjectileSpell> projectiles = new ArrayList<EntityProjectileSpell>();
        EntityProjectileSpell projectileSpell = new EntityProjectileSpell(world, resolver);
        projectileSpell.m_6034_((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_());
        projectiles.add(projectileSpell);
        int numSplits = stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        for (int i = 1; i < numSplits + 1; ++i) {
            Direction offset = shooter.m_6350_().m_122427_();
            if (i % 2 == 0) {
                offset = offset.m_122424_();
            }
            BlockPos projPos = pos.m_5484_(offset, i);
            projPos = projPos.m_7918_(0, 2, 0);
            EntityProjectileSpell spell = new EntityProjectileSpell(world, resolver);
            spell.m_6034_((double)projPos.m_123341_(), (double)projPos.m_123342_(), (double)projPos.m_123343_());
            projectiles.add(spell);
        }
        for (EntityProjectileSpell proj : projectiles) {
            proj.m_20256_(new Vec3(0.0, -0.1, 0.0));
            world.m_7967_((Entity)proj);
        }
    }

    public CastResolveType onCast(ItemStack stack, LivingEntity shooter, Level world, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        this.summonProjectiles(world, shooter, spellStats, resolver);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnBlock(UseOnContext context, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Level world = context.m_43725_();
        Player shooter = context.m_43723_();
        this.summonProjectiles(world, (LivingEntity)shooter, spellStats, resolver);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        caster.m_7618_(EntityAnchorArgument.Anchor.EYES, blockRayTraceResult.m_82450_().m_82520_(0.0, 0.0, 0.0));
        this.summonProjectiles(caster.m_20193_(), blockRayTraceResult.m_82425_(), caster, spellStats, resolver);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnEntity(ItemStack stack, LivingEntity caster, Entity target, InteractionHand hand, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.summonProjectiles(caster.m_20193_(), caster, spellStats, resolver);
        return CastResolveType.SUCCESS;
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    protected int getDefaultManaCost() {
        return 200;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentSensitive.INSTANCE, AugmentAccelerate.INSTANCE, AugmentDecelerate.INSTANCE, AugmentAOE.INSTANCE, AugmentSplit.INSTANCE, AugmentPierce.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE});
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.PROJECTILE_TTL = builder.comment("Max lifespan of the projectile, in seconds.").defineInRange("max_lifespan", 60, 0, Integer.MAX_VALUE);
    }

    public int getProjectileLifespan() {
        return this.PROJECTILE_TTL != null ? (Integer)this.PROJECTILE_TTL.get() : 60;
    }
}

