/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.common.network.PacketRayEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectChaining
extends AbstractEffect {
    public static final EffectChaining INSTANCE = new EffectChaining("chaining", "Chaining");
    public ForgeConfigSpec.IntValue BASE_MAX_BLOCKS;
    public ForgeConfigSpec.IntValue BONUS_BLOCKS;
    public ForgeConfigSpec.DoubleValue BASE_BLOCK_DISTANCE;
    public ForgeConfigSpec.DoubleValue BONUS_BLOCK_DISTANCE;
    public ForgeConfigSpec.IntValue BASE_MAX_ENTITIES;
    public ForgeConfigSpec.IntValue BONUS_ENTITIES;
    public ForgeConfigSpec.DoubleValue BASE_ENTITY_DISTANCE;
    public ForgeConfigSpec.DoubleValue BONUS_ENTITY_DISTANCE;

    public EffectChaining(String tag, String description) {
        super(CompatRL.tmg(tag), description);
    }

    protected void addDefaultInvalidCombos(Set<ResourceLocation> defaults) {
        defaults.addAll(Stream.of(EffectLinger.INSTANCE, EffectWall.INSTANCE).map(AbstractSpellPart::getRegistryName).toList());
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", 1, 1, Integer.MAX_VALUE);
        this.BASE_MAX_BLOCKS = builder.comment("Base maximum number of blocks struck when targeting blocks").defineInRange("base_max_blocks", 16, 1, Integer.MAX_VALUE);
        this.BONUS_BLOCKS = builder.comment("Bonus to maximum blocks per augment").defineInRange("bonus_blocks", 16, 1, Integer.MAX_VALUE);
        this.BASE_BLOCK_DISTANCE = builder.comment("Base search distance around each target block").defineInRange("base_block_search_distance_euclidean", 1.75, 1.0, 2.147483647E9);
        this.BONUS_BLOCK_DISTANCE = builder.comment("Bonus search distance around each target block per augment").defineInRange("bonus_block_distance_euclidean", 1.0, 1.0, 2.147483647E9);
        this.BASE_MAX_ENTITIES = builder.comment("Base maximum number of entities struck when targeting entities").defineInRange("base_max_entities", 8, 1, Integer.MAX_VALUE);
        this.BONUS_ENTITIES = builder.comment("Bonus to maximum entities per augment").defineInRange("bonus_entities", 16, 1, Integer.MAX_VALUE);
        this.BASE_ENTITY_DISTANCE = builder.comment("Base search distance around each target entity").defineInRange("base_entity_distance", 8.0, 0.0, Double.MAX_VALUE);
        this.BONUS_ENTITY_DISTANCE = builder.comment("Bonus search distance around each target entity per augment").defineInRange("bonus_entity_distance", 4.0, 0.0, Double.MAX_VALUE);
    }

    private static Vec3 getBlockCenter(BlockPos blockPos) {
        return new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        int maxBlocks = (int)((double)((Integer)this.BASE_MAX_BLOCKS.get()).intValue() + (double)((Integer)this.BONUS_BLOCKS.get()).intValue() * spellStats.getAoeMultiplier());
        double searchDistance = (Double)this.BASE_BLOCK_DISTANCE.get() + (Double)this.BONUS_BLOCK_DISTANCE.get() * (double)spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE);
        int searchBlockDistance = (int)Math.ceil(searchDistance);
        double searchDistanceSqr = searchDistance * searchDistance;
        BlockState struck = world.m_8055_(rayTraceResult.m_82425_());
        Iterable<Edge<BlockPos>> chain = EffectChaining.SearchTargets(Collections.singleton(rayTraceResult.m_82425_()), maxBlocks, EffectChaining::getBlockCenter, bp -> EffectChaining.getBlockCenter(bp).m_82546_(EffectChaining.getBlockCenter(rayTraceResult.m_82425_())).m_82553_() * 0.01, (bp, isMatch) -> BlockPos.m_121990_((BlockPos)bp.m_7918_(searchBlockDistance, searchBlockDistance, searchBlockDistance), (BlockPos)bp.m_7918_(-searchBlockDistance, -searchBlockDistance, -searchBlockDistance)).filter(nbp -> EffectChaining.getBlockCenter(bp).m_82557_(EffectChaining.getBlockCenter(nbp)) <= searchDistanceSqr && isMatch.test(nbp)).map(BlockPos::m_7949_).collect(Collectors.toCollection(ArrayList::new)), bp -> world.m_8055_(bp).m_60713_(struck.m_60734_()));
        spellContext.setCanceled(true);
        Spell continuation = spellContext.getRemainingSpell();
        for (Edge<BlockPos> edge : chain) {
            Vec3 toCenter = EffectChaining.getBlockCenter((BlockPos)edge.to);
            BlockHitResult chainedRayTraceResult = new BlockHitResult(toCenter, rayTraceResult.m_82434_(), (BlockPos)edge.to, true);
            PacketRayEffect.send(world, spellContext, EffectChaining.getBlockCenter((BlockPos)edge.from), EffectChaining.getBlockCenter((BlockPos)edge.to));
            SpellContext newContext = spellContext.clone().withSpell(continuation);
            resolver.getNewResolver(newContext).onResolveEffect(world, (HitResult)chainedRayTraceResult);
        }
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        int maxEntities = (int)((double)((Integer)this.BASE_MAX_ENTITIES.get()).intValue() + (double)((Integer)this.BONUS_ENTITIES.get()).intValue() * spellStats.getAoeMultiplier());
        double distance = (Double)this.BASE_ENTITY_DISTANCE.get() + (Double)this.BONUS_ENTITY_DISTANCE.get() * (double)spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE);
        double distanceSqr = distance * distance;
        Entity struck = rayTraceResult.m_82443_();
        spellContext.setCanceled(true);
        Iterable<Edge<Entity>> chain = EffectChaining.SearchTargets(Collections.singleton(struck), maxEntities, Entity::m_20182_, e -> (double)e.m_20270_(struck) * 0.01, (e, isMatch) -> world.m_6443_(Entity.class, new AABB(e.m_20182_().f_82479_ + distance, e.m_20182_().f_82480_ + distance, e.m_20182_().f_82481_ + distance, e.m_20182_().f_82479_ - distance, e.m_20182_().f_82480_ - distance, e.m_20182_().f_82481_ - distance), t -> t.m_20182_().m_82557_(e.m_20182_()) <= distanceSqr && isMatch.test(t)), e -> e != shooter);
        Spell continuation = spellContext.getRemainingSpell();
        for (Edge<Entity> edge : chain) {
            PacketRayEffect.send(world, spellContext, ((Entity)edge.from).m_20182_(), ((Entity)edge.to).m_20182_());
            SpellContext newContext = spellContext.clone().withSpell(continuation);
            resolver.getNewResolver(newContext).onResolveEffect(world, (HitResult)new EntityHitResult((Entity)edge.to));
        }
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    public int getDefaultManaCost() {
        return 300;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentSensitive.INSTANCE});
    }

    public static Iterable<BlockPos> SearchBlockStates(Level world, Collection<BlockPos> start, int maxBlocks, int searchDistance, Predicate<BlockState> isMatch) {
        LinkedList<BlockPos> searchQueue = new LinkedList<BlockPos>(start);
        HashSet<BlockPos> searched = new HashSet<BlockPos>(start);
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        while (!searchQueue.isEmpty() && found.size() < maxBlocks) {
            BlockPos current = searchQueue.removeFirst();
            BlockState state = world.m_8055_(current);
            if (!isMatch.test(state)) continue;
            found.add(current);
            BlockPos.m_121990_((BlockPos)current.m_7918_(searchDistance, searchDistance, searchDistance), (BlockPos)current.m_7918_(-searchDistance, -searchDistance, -searchDistance)).forEach(neighborMutable -> {
                if (searched.contains(neighborMutable)) {
                    return;
                }
                BlockPos neighbor = neighborMutable.m_7949_();
                searched.add(neighbor);
                searchQueue.add(neighbor);
            });
        }
        return found;
    }

    public static Iterable<Edge<Entity>> SearchEntities(Level world, Collection<Entity> start, int maxEntities, double searchDistance, Predicate<Entity> isMatch) {
        HashMap<Entity, Edge<Entity>> bestEdgeForTo = new HashMap<Entity, Edge<Entity>>();
        PriorityQueue<Edge> searchQueue = new PriorityQueue<Edge>(Comparator.comparingDouble(item -> item.distanceSqr));
        HashSet<Entity> selected = new HashSet<Entity>();
        ArrayList<Edge<Entity>> selectedEdges = new ArrayList<Edge<Entity>>();
        double searchDistanceSqr = searchDistance * searchDistance;
        start.stream().filter(isMatch).map(e -> new Edge<Entity>(0.0, (Entity)e, (Entity)e)).forEach(searchQueue::add);
        while (!searchQueue.isEmpty() && selected.size() < maxEntities) {
            Edge currentEdge = searchQueue.poll();
            Entity current = (Entity)currentEdge.to;
            selected.add(current);
            selectedEdges.add(currentEdge);
            Vec3 position = current.m_20182_();
            List neighbors = world.m_6443_(Entity.class, new AABB(position.f_82479_ + searchDistance, position.f_82480_ + searchDistance, position.f_82481_ + searchDistance, position.f_82479_ - searchDistance, position.f_82480_ - searchDistance, position.f_82481_ - searchDistance), e -> e.m_20182_().m_82557_(current.m_20182_()) <= searchDistanceSqr && isMatch.test((Entity)e) && !selected.contains(e));
            for (Entity neighbor : neighbors) {
                double distanceSqr = neighbor.m_20182_().m_82557_(current.m_20182_());
                Edge bestKnown = (Edge)bestEdgeForTo.get(neighbor);
                if (bestKnown != null && !(bestKnown.distanceSqr > distanceSqr)) continue;
                Edge<Entity> toAdd = new Edge<Entity>(distanceSqr, current, neighbor);
                if (bestKnown != null) {
                    searchQueue.remove(bestKnown);
                }
                searchQueue.add(toAdd);
                bestEdgeForTo.put(neighbor, toAdd);
            }
        }
        return selectedEdges;
    }

    public static <T> Iterable<Edge<T>> SearchTargets(Collection<T> start, int maxTargets, Function<T, Vec3> getPosition, Function<T, Double> distanceAdjustment, BiFunction<T, Predicate<T>, Collection<T>> expandSearchNode, Predicate<T> isMatch) {
        HashMap bestEdgeForTo = new HashMap();
        PriorityQueue<Edge> searchQueue = new PriorityQueue<Edge>(Comparator.comparingDouble(item -> item.distanceSqr));
        HashSet selected = new HashSet();
        ArrayList<Edge<T>> selectedEdges = new ArrayList<Edge<T>>();
        start.stream().filter(isMatch).map(e -> new Edge<Object>(0.0, e, e)).forEach(searchQueue::add);
        while (!searchQueue.isEmpty() && selected.size() < maxTargets) {
            Edge currentEdge = searchQueue.poll();
            Object current = currentEdge.to;
            selected.add(current);
            selectedEdges.add(currentEdge);
            Collection<T> neighbors = expandSearchNode.apply(current, e -> !selected.contains(e) && isMatch.test(e));
            Vec3 position = getPosition.apply(current);
            for (T neighbor : neighbors) {
                double distanceSqr = getPosition.apply(neighbor).m_82557_(position) + distanceAdjustment.apply(neighbor);
                Edge bestKnown = (Edge)bestEdgeForTo.get(neighbor);
                if (bestKnown != null && !(bestKnown.distanceSqr > distanceSqr)) continue;
                Edge toAdd = new Edge(distanceSqr, current, neighbor);
                if (bestKnown != null) {
                    searchQueue.remove(bestKnown);
                }
                searchQueue.add(toAdd);
                bestEdgeForTo.put(neighbor, toAdd);
            }
        }
        return selectedEdges;
    }

    public static class Edge<T> {
        public double distanceSqr;
        public T from;
        public T to;

        public Edge(double distanceSqr, T from, T to) {
            this.distanceSqr = distanceSqr;
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return Double.compare(edge.distanceSqr, this.distanceSqr) == 0 && Objects.equals(this.from, edge.from) && Objects.equals(this.to, edge.to);
        }

        public int hashCode() {
            return Objects.hash(this.distanceSqr, this.from, this.to);
        }
    }
}

