/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outer_end.feature;

import blueduck.outer_end.feature.helpers.RotatableFeaturePart;
import blueduck.outer_end.registry.OuterEndBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class AzureTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private static ChunkAccess chunkGenerating = null;
    private static final Direction[] offsets = new Direction[]{Direction.NORTH, Direction.UP, Direction.NORTH, Direction.UP, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.WEST, null, Direction.EAST, null, Direction.WEST, null, Direction.NORTH, Direction.UP, Direction.EAST, Direction.UP, Direction.DOWN, Direction.WEST, Direction.WEST, Direction.UP};
    private static final RotatableFeaturePart petalFoldPart = new RotatableFeaturePart(offsets);

    public AzureTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> reader) {
        if (!reader.m_159774_().m_8055_(reader.m_159777_()).m_60713_(Blocks.f_50016_) && reader.m_159774_().m_8055_(reader.m_159777_()).m_60838_((BlockGetter)reader.m_159774_(), reader.m_159777_()) && !reader.m_159774_().m_8055_(reader.m_159777_()).m_60713_((Block)OuterEndBlocks.AZURE_BUD.get()) || !reader.m_159774_().m_8055_(reader.m_159777_().m_7495_()).m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("outer_end:end_plantable_on")))) {
            return false;
        }
        AzureTreeFeature.generateTree(reader);
        return true;
    }

    public static void generateTree(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (context.m_225041_().m_188500_() < 0.0675) {
            AzureTreeFeature.generateTreeLarge(context);
        } else if (context.m_225041_().m_188500_() < 0.25) {
            AzureTreeFeature.generateTreeSmallest(context);
        } else {
            AzureTreeFeature.generateTreeSmall(context);
        }
    }

    public static void generateTreeLarge(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int yPos;
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource rand = context.m_225041_();
        AzureTreeFeature.setBlock(world, pos, ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        int height = rand.m_188503_(4) + 8;
        for (yPos = 0; yPos <= height; ++yPos) {
            if (yPos < height) {
                AzureTreeFeature.setLog(world, pos.m_7918_(0, yPos, 0), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
            }
            if (yPos > 1 && yPos < height - 1) continue;
            AzureTreeFeature.setLog(world, pos.m_7918_(1, yPos, 0), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
            AzureTreeFeature.setLog(world, pos.m_7918_(-1, yPos, 0), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
            AzureTreeFeature.setLog(world, pos.m_7918_(0, yPos, 1), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
            AzureTreeFeature.setLog(world, pos.m_7918_(0, yPos, -1), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        }
        BlockState leavesState = (BlockState)((Block)OuterEndBlocks.AZURE_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
        petalFoldPart.generate(Direction.NORTH, pos.m_7918_(0, --yPos, 1), posPlace -> AzureTreeFeature.setLeaves(world, posPlace, leavesState));
        petalFoldPart.generate(Direction.SOUTH, pos.m_7918_(0, yPos, -1), posPlace -> AzureTreeFeature.setLeaves(world, posPlace, leavesState));
        petalFoldPart.generate(Direction.EAST, pos.m_7918_(-1, yPos, 0), posPlace -> AzureTreeFeature.setLeaves(world, posPlace, leavesState));
        petalFoldPart.generate(Direction.WEST, pos.m_7918_(1, yPos, 0), posPlace -> AzureTreeFeature.setLeaves(world, posPlace, leavesState));
        AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos, 0), ((Block)OuterEndBlocks.AZURE_STAMEN.get()).m_49966_());
        for (int stamenPosY = 0; stamenPosY < rand.m_188503_(3) + 3; ++stamenPosY) {
            AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos + stamenPosY + 1, 0), ((Block)OuterEndBlocks.AZURE_STAMEN.get()).m_49966_());
        }
    }

    public static void generateTreeSmall(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockState leavesState;
        int yPos;
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource rand = context.m_225041_();
        AzureTreeFeature.setBlock(world, pos, ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        int height = rand.m_188503_(4) + 6;
        for (yPos = 0; yPos < height; ++yPos) {
            AzureTreeFeature.setLog(world, pos.m_7918_(0, yPos, 0), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        }
        AzureTreeFeature.setLog(world, pos.m_7918_(1, 0, 0), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        AzureTreeFeature.setLog(world, pos.m_7918_(-1, 0, 0), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        AzureTreeFeature.setLog(world, pos.m_7918_(0, 0, 1), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        AzureTreeFeature.setLog(world, pos.m_7918_(0, 0, -1), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        BlockState leavesState2 = (BlockState)((Block)OuterEndBlocks.AZURE_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
        AzureTreeFeature.setLeaves(world, pos.m_7918_(1, yPos - 1, 0), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.m_7918_(-1, yPos - 1, 0), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos - 1, 1), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos - 1, -1), leavesState2);
        for (int horizontalOffset = 0; horizontalOffset <= 2; ++horizontalOffset) {
            leavesState = (BlockState)((Block)OuterEndBlocks.AZURE_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(horizontalOffset + 1));
            AzureTreeFeature.setLeaves(world, pos.m_7918_(horizontalOffset, yPos, 0), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(-horizontalOffset, yPos, 0), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos, horizontalOffset), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos, -horizontalOffset), leavesState);
        }
        for (int yOff = 0; yOff <= 1; ++yOff) {
            leavesState = (BlockState)((Block)OuterEndBlocks.AZURE_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(3));
            AzureTreeFeature.setLeaves(world, pos.m_7918_(1, yPos + yOff, 1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(1, yPos + yOff, -1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(-1, yPos + yOff, -1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(-1, yPos + yOff, 1), leavesState);
        }
        AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos + 1, 0), ((Block)OuterEndBlocks.AZURE_STAMEN.get()).m_49966_());
    }

    public static void generateTreeSmallest(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockState leavesState;
        int yPos;
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource rand = context.m_225041_();
        AzureTreeFeature.setBlock(world, pos, ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        int height = rand.m_188503_(3) + 4;
        for (yPos = 0; yPos < height; ++yPos) {
            AzureTreeFeature.setLog(world, pos.m_7918_(0, yPos, 0), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        }
        AzureTreeFeature.setLog(world, pos.m_7918_(1, 0, 0), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        AzureTreeFeature.setLog(world, pos.m_7918_(-1, 0, 0), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        AzureTreeFeature.setLog(world, pos.m_7918_(0, 0, 1), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        AzureTreeFeature.setLog(world, pos.m_7918_(0, 0, -1), ((Block)OuterEndBlocks.AZURE_STEM.get()).m_49966_());
        BlockState leavesState2 = (BlockState)((Block)OuterEndBlocks.AZURE_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
        AzureTreeFeature.setLeaves(world, pos.m_7918_(1, yPos - 1, 0), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.m_7918_(-1, yPos - 1, 0), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos - 1, 1), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos - 1, -1), leavesState2);
        for (int horizontalOffset = 0; horizontalOffset <= 2; ++horizontalOffset) {
            leavesState = (BlockState)((Block)OuterEndBlocks.AZURE_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(horizontalOffset + 1));
            AzureTreeFeature.setLeaves(world, pos.m_7918_(horizontalOffset, yPos, 0), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(-horizontalOffset, yPos, 0), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos, horizontalOffset), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos, -horizontalOffset), leavesState);
        }
        for (int yOff = 0; yOff <= 1; ++yOff) {
            leavesState = (BlockState)((Block)OuterEndBlocks.AZURE_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(3));
            AzureTreeFeature.setLeaves(world, pos.m_7918_(1, yPos + yOff, 1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(1, yPos + yOff, -1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(-1, yPos + yOff, -1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.m_7918_(-1, yPos + yOff, 1), leavesState);
        }
        AzureTreeFeature.setLeaves(world, pos.m_7918_(0, yPos + 1, 0), ((Block)OuterEndBlocks.AZURE_STAMEN.get()).m_49966_());
    }

    public static void setLeaves(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (world.m_8055_(pos).m_247087_()) {
            AzureTreeFeature.setBlock(world, pos, state);
        }
    }

    public static void setLog(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (world.m_8055_(pos).m_247087_()) {
            AzureTreeFeature.setBlock(world, pos, state);
        }
    }

    public static void setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (world instanceof WorldGenRegion) {
            if (chunkGenerating == null || !chunkGenerating.m_7697_().equals((Object)new ChunkPos(pos))) {
                chunkGenerating = ((WorldGenRegion)world).m_46865_(pos);
            }
            chunkGenerating.m_6978_(pos, state, false);
        } else {
            world.m_7731_(pos, state, 3);
        }
    }
}

