/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outer_end.entity;

import blueduck.outer_end.registry.OuterEndSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class Himmelite
extends Monster {
    private static final EntityDataAccessor<Integer> BITE_FACTOR = SynchedEntityData.m_135353_(Himmelite.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int lastBiteFactor = 0;
    private boolean updateLastFactor = false;
    boolean retreating = false;
    boolean justFinishedRetreat = false;

    public Himmelite(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    public void addBehaviourGoals() {
        this.f_21345_.m_25352_(2, (Goal)new HimmeliteAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new HimmeliteRetreatGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22276_, 12.0);
    }

    public static boolean canSpawn(EntityType<Himmelite> entityType, ServerLevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource rand) {
        return Himmelite.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)OuterEndSounds.ENTITY_HIMMELITE_IDLE.get();
    }

    public SoundEvent m_7975_(DamageSource p_33579_) {
        return (SoundEvent)OuterEndSounds.ENTITY_HIMMELITE_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)OuterEndSounds.ENTITY_HIMMELITE_DEATH.get();
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_21525_() || this.m_9236_().f_46443_) {
            if (this.m_9236_().f_46443_ && (this.updateLastFactor || this.getBiteFactor() == 0)) {
                this.lastBiteFactor = this.getBiteFactor();
                this.updateLastFactor = false;
            }
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target != null && !this.retreating) {
            if (this.getBiteFactor() >= 17) {
                this.setBiteFactor(0);
            }
            if (this.m_20270_((Entity)target) <= 10.0f && this.getBiteFactor() != 16) {
                this.incrementBiteFactor(1);
            } else if (this.m_20270_((Entity)target) >= 10.0f) {
                this.setBiteFactor(0);
            }
        } else {
            this.setBiteFactor(-1);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BITE_FACTOR, (Object)0);
    }

    public void setBiteFactor(int amt) {
        this.f_19804_.m_135381_(BITE_FACTOR, (Object)amt);
    }

    public void incrementBiteFactor(int amt) {
        this.f_19804_.m_135381_(BITE_FACTOR, (Object)(this.getBiteFactor() + amt));
    }

    public int getBiteFactor() {
        return (Integer)this.f_19804_.m_135370_(BITE_FACTOR);
    }

    public int getLastBiteFactor() {
        return this.lastBiteFactor;
    }

    public void updateBiteFactor() {
        this.updateLastFactor = true;
    }

    class HimmeliteAttackGoal
    extends MeleeAttackGoal {
        public HimmeliteAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= d0 && Himmelite.this.getBiteFactor() == 16) {
                Himmelite.this.setBiteFactor(17);
                this.m_25563_();
                this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                this.f_25540_.m_7327_((Entity)pEnemy);
                Himmelite.this.retreating = true;
            }
        }

        public void m_8037_() {
            super.m_8037_();
            if ((this.f_25543_ == null || this.f_25543_.m_77392_()) && this.m_8045_()) {
                LivingEntity target = this.f_25540_.m_5448_();
                Path pth = this.f_25540_.m_21573_().m_6570_((Entity)target, 1);
                if (pth != null) {
                    this.f_25543_ = pth;
                }
            }
        }

        public boolean m_8036_() {
            if (Himmelite.this.justFinishedRetreat) {
                Himmelite.this.justFinishedRetreat = false;
                LivingEntity target = this.f_25540_.m_5448_();
                if (target == null) {
                    return false;
                }
                if (!target.m_6084_()) {
                    return false;
                }
                this.f_25543_ = this.f_25540_.m_21573_().m_6570_((Entity)target, 0);
                if (this.f_25543_ != null) {
                    return true;
                }
                return this.m_6639_(target) >= this.f_25540_.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            }
            return super.m_8036_() && !Himmelite.this.retreating;
        }

        public boolean m_8045_() {
            return super.m_8045_() && !Himmelite.this.retreating;
        }
    }

    class HimmeliteRetreatGoal
    extends Goal {
        PathfinderMob mob;
        int ticksSinceLastCheck = 5;
        Path path;
        BlockPos target;

        public HimmeliteRetreatGoal(PathfinderMob mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return Himmelite.this.retreating;
        }

        public boolean m_8045_() {
            return Himmelite.this.retreating;
        }

        private void makePath() {
            Vec2 v2 = new Vec2((float)this.mob.m_20154_().f_82479_, (float)this.mob.m_20154_().f_82481_).m_165902_();
            Vec3 targ = this.mob.m_20182_().m_82549_(new Vec3((double)(v2.f_82470_ * -20.0f), 0.0, (double)(v2.f_82471_ * -20.0f)));
            int y = this.mob.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, Mth.m_14107_((double)targ.f_82479_), Mth.m_14107_((double)targ.f_82481_));
            this.target = BlockPos.m_274561_((double)targ.f_82479_, (double)y, (double)targ.f_82481_);
            this.path = this.mob.m_21573_().m_7864_(this.target, 1);
            if (this.path != null) {
                this.mob.m_21573_().m_26536_(this.path, 1.0);
            }
        }

        public void m_8056_() {
            super.m_8056_();
            this.makePath();
        }

        public void m_8037_() {
            boolean farEnough;
            this.mob.m_21573_().m_26536_(this.path, 1.0);
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                Himmelite.this.retreating = false;
                return;
            }
            double d2Targ = this.mob.m_20270_((Entity)target);
            boolean bl = farEnough = d2Targ >= 10.0;
            if (farEnough) {
                Himmelite.this.retreating = false;
                Himmelite.this.justFinishedRetreat = true;
                return;
            }
            if (this.pathDone()) {
                this.makePath();
                return;
            }
            if (this.ticksSinceLastCheck-- < 0) {
                Path pth = this.mob.m_21573_().m_6570_((Entity)target, 1);
                if (pth != null) {
                    this.path = pth;
                }
                this.ticksSinceLastCheck = 5;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean pathDone() {
            Vec3 pos = this.mob.m_20182_();
            if (this.path == null) return true;
            if (this.path.m_77392_()) return true;
            Vec3 vec3 = new Vec3(pos.f_82479_, (double)this.path.m_77395_().f_77272_, pos.f_82481_);
            if (!(vec3.m_82554_(this.path.m_77395_().m_164701_()) <= 1.0)) return false;
            return true;
        }
    }
}

