/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.world.content.WorldContent;

public class LampColoredBlock
extends ColoredBlock {
    private final DyeColor _dyeColor;
    private final boolean _inverted;

    public LampColoredBlock(DyeColor color, BlockBehaviour.Properties properties, boolean isInverted) {
        super((ColorSource)new ColorSource.Dye(color), properties);
        this._dyeColor = color;
        this._inverted = isInverted;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CoreStateProperties.LightValue, (Comparable)Integer.valueOf(this._inverted ? 15 : 0)));
    }

    public static Supplier<Block> blockSupplier(DyeColor color) {
        return () -> new LampColoredBlock(color, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.XYLOPHONE).m_60918_(SoundType.f_154654_).m_155954_(Blocks.f_50058_.m_155943_()).m_60924_((p_61036_, p_61037_, p_61038_) -> false), false);
    }

    public static Supplier<Block> blockSupplierInverted(DyeColor color) {
        return () -> new LampColoredBlock(color, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.XYLOPHONE).m_60918_(SoundType.f_154654_).m_155954_(Blocks.f_50058_.m_155943_()).m_60924_((p_61036_, p_61037_, p_61038_) -> false), true);
    }

    public static Supplier<Item> itemSupplier(DyeColor dyeColor, RegistryObject<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), new Item.Properties());
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)CoreStateProperties.LightValue);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CoreStateProperties.Spawnable});
        builder.m_61104_(new Property[]{CoreStateProperties.LightValue});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (player.m_7500_()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        return new ItemStack((ItemLike)this.getCurrentMap(state.getLightEmission(level, pos), state).get(DyeColor.WHITE).block(), 1);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        EnumMap<DyeColor, BlockContent> currentMap;
        BlockContent blockType;
        InteractionResult interactionResult = ColoredBlock.tryToAllowSpawns((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)interactionHand);
        if (interactionResult != InteractionResult.PASS) {
            return interactionResult;
        }
        ItemStack stack = player.m_21120_(interactionHand);
        DyeColor dyeColor = DyeColor.getColor((ItemStack)stack);
        if (dyeColor != null && dyeColor != this._dyeColor && (blockType = (currentMap = this.getCurrentMap(state.getLightEmission((BlockGetter)level, pos), state)).get(dyeColor)).block() != this) {
            level.m_7731_(pos, (BlockState)((BlockState)blockType.block().m_49966_().m_61124_((Property)CoreStateProperties.Spawnable, (Comparable)((Boolean)state.m_61143_((Property)CoreStateProperties.Spawnable)))).m_61124_((Property)CoreStateProperties.LightValue, (Comparable)((Integer)state.m_61143_((Property)CoreStateProperties.LightValue))), 11);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        ItemStack offhandStack = Objects.requireNonNull(context.m_43723_()).m_21206_();
        BlockState state = this.m_49966_();
        int light = state.getLightEmission((BlockGetter)context.m_43725_(), context.m_8083_());
        DyeColor color = DyeColor.getColor((ItemStack)offhandStack);
        if (color != null) {
            state = this.getCurrentMap(light, state).get(color).block().m_49966_();
        }
        int redstone = context.m_43725_().m_277086_(context.m_8083_());
        if (this._inverted) {
            redstone = 15 - redstone;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CoreStateProperties.LightValue, (Comparable)Integer.valueOf(redstone));
    }

    private EnumMap<DyeColor, BlockContent> getCurrentMap(int light, BlockState state) {
        return this._inverted ? WorldContent.LampRgbGlowingInverted : WorldContent.LampRgbGlowing;
    }

    public void m_6861_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block otherBlock, @NotNull BlockPos otherPos, boolean p_55671_) {
        if (!level.f_46443_) {
            Integer lightValue = (Integer)state.m_61143_((Property)CoreStateProperties.LightValue);
            int redstone = level.m_277086_(pos);
            if (this._inverted) {
                redstone = 15 - redstone;
            }
            if (lightValue != redstone) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CoreStateProperties.LightValue, (Comparable)Integer.valueOf(redstone)), 2);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        Integer lightValue = (Integer)state.m_61143_((Property)CoreStateProperties.LightValue);
        int redstone = level.m_277086_(pos);
        if (this._inverted) {
            redstone = 15 - redstone;
        }
        if (lightValue != redstone) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CoreStateProperties.LightValue, (Comparable)Integer.valueOf(redstone)), 2);
        }
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        int color = this._colorSource.getColor();
        float l = Mth.m_14036_((float)((float)((Integer)state.m_61143_((Property)CoreStateProperties.LightValue)).intValue() / 15.0f), (float)0.2f, (float)1.0f);
        return ColorUtils.multiply((int)color, (float)l);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        if (index != 0) {
            return -1;
        }
        if (stack.m_41720_() == WorldContent.LampRgbGlowing.get(DyeColor.WHITE).item()) {
            return ColorUtils.multiply((int)ColorUtils.getColorTime((int)0), (float)0.2f);
        }
        if (stack.m_41720_() == WorldContent.LampRgbGlowingInverted.get(DyeColor.WHITE).item()) {
            return ColorUtils.getColorTime((int)0);
        }
        return this._colorSource.getColor();
    }
}

