/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.trotting_wagons.common.entities.base;

import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.UUID;
import net.favouriteless.trotting_wagons.ServerConfig;
import net.favouriteless.trotting_wagons.TrottingWagons;
import net.favouriteless.trotting_wagons.client.TWClient;
import net.favouriteless.trotting_wagons.common.entities.base.AbstractGeckolibVehicle;
import net.favouriteless.trotting_wagons.common.init.TWItems;
import net.favouriteless.trotting_wagons.common.util.LevelUtils;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractWagon
extends AbstractGeckolibVehicle {
    private static final Random RANDOM = new Random();
    private static final EntityDataAccessor<Float> DATA_ID_HEALTH = SynchedEntityData.m_135353_(AbstractWagon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<OptionalInt> DATA_ID_COLOR = SynchedEntityData.m_135353_(AbstractWagon.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    public static final double GRAVITY = 0.04;
    public static final int SPEED_LEVELS = 3;
    public static final double HORIZONTAL_TETHER = 0.25;
    public final double speed;
    private final double acceleration;
    private final float turnRate;
    private final int maxHealth;
    private final double horseX;
    private final double horseY;
    private final float shaftAngle;
    public UUID owner;
    private int speedLevel = 0;
    private double currentSpeed;
    private final Mob[] horses = new Mob[2];
    private final UUID[] horseUuids = new UUID[2];

    public AbstractWagon(EntityType<? extends AbstractWagon> type, Level level, double wheelWidth, double wheelLength, Vec3[] riders, double speed, double acceleration, double turnRate, int maxHealth, double horseX, double horseY, float shaftAngle) {
        super(type, level, wheelWidth, wheelLength, riders);
        this.speed = speed;
        this.acceleration = acceleration;
        this.turnRate = (float)turnRate;
        this.maxHealth = maxHealth;
        this.horseX = horseX;
        this.horseY = horseY;
        this.shaftAngle = shaftAngle;
        this.setHealth(maxHealth);
    }

    @Override
    public void m_8119_() {
        if (this.f_19803_ && this.m_9236_().f_46443_) {
            TWClient.createWagonSound(this);
        }
        if (!this.m_9236_().f_46443_) {
            this.validateHorses();
        }
        super.m_8119_();
    }

    private void validateHorses() {
        if (this.f_19803_ || this.m_9236_().m_46467_() % 100L == 0L) {
            this.setHorse(this.getHorse(Side.LEFT), Side.LEFT);
            this.setHorse(this.getHorse(Side.RIGHT), Side.RIGHT);
        }
        this.validate(Side.LEFT);
        this.validate(Side.RIGHT);
    }

    private void validate(Side side) {
        Mob horse = this.getHorse(side);
        if (horse == null) {
            return;
        }
        if (horse.m_21523_()) {
            this.setHorse(null, side);
        } else if (!this.isHorseInRange(side)) {
            horse.m_146884_(this.getHorsePos(side));
        }
    }

    private boolean isHorseInRange(Side side) {
        Mob horse = this.getHorse(side);
        if (horse == null) {
            return false;
        }
        Vec3 displacement = horse.m_20182_().m_82546_(this.getHorsePos(side));
        return horse.m_6084_() && displacement.m_165925_() < 0.25;
    }

    @Override
    public void moveTick() {
        Mob leftHorse = this.getHorse(Side.LEFT);
        Mob rightHorse = this.getHorse(Side.RIGHT);
        if (!this.m_20160_() || !(this.m_6688_() instanceof Player) || leftHorse == null || rightHorse == null) {
            this.speedLevel = 0;
            this.setSteeringImpulse(0.0f);
        }
        this.handleSteering();
        this.handleAcceleration();
        Vec3 forward = this.m_20156_().m_82542_(1.0, 0.0, 1.0);
        Vec3 velocity = forward.m_82490_(this.currentSpeed);
        Vec3 leftMove = leftHorse != null ? leftHorse.m_20272_(velocity) : null;
        Vec3 rightMove = rightHorse != null ? rightHorse.m_20272_(velocity) : null;
        Vec3 move = this.m_20272_(velocity);
        if (leftMove != null && leftMove.m_165925_() < move.m_165925_()) {
            move = leftMove;
        }
        if (rightMove != null && rightMove.m_165925_() < move.m_165925_()) {
            move = rightMove;
        }
        move = move.m_82542_(1.0, 0.0, 1.0);
        if (!this.m_20068_()) {
            move = move.m_82520_(0.0, -0.04, 0.0);
        }
        if (leftHorse != null) {
            leftHorse.m_20256_(move.m_82520_(0.0, leftHorse.m_20184_().f_82480_, 0.0));
            leftHorse.m_6478_(MoverType.SELF, leftHorse.m_20184_());
        }
        if (rightHorse != null) {
            rightHorse.m_20256_(move.m_82520_(0.0, rightHorse.m_20184_().f_82480_, 0.0));
            rightHorse.m_6478_(MoverType.SELF, rightHorse.m_20184_());
        }
        this.m_20256_(move.m_82520_(0.0, this.m_20184_().f_82480_, 0.0));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_146926_(this.rotlerp(this.m_146909_(), this.calculateTargetXRot(), (float)(9.0 * this.currentSpeed / (3.0 * this.currentSpeed))));
    }

    private void handleSteering() {
        float speedPercent = (float)(this.currentSpeed / (3.0 * this.speed));
        float steer = -this.getSteeringImpulse() * speedPercent * this.turnRate;
        if (steer != 0.0f) {
            Mob leftHorse = this.getHorse(Side.LEFT);
            Mob rightHorse = this.getHorse(Side.RIGHT);
            Vec3 leftDisplace = this.collideSteering(Side.LEFT, steer);
            Vec3 rightDisplace = this.collideSteering(Side.RIGHT, steer);
            if (!leftDisplace.equals((Object)Vec3.f_82478_) && !rightDisplace.equals((Object)Vec3.f_82478_)) {
                this.m_146922_(Mth.m_14177_((float)(this.m_146908_() + steer)));
                float yRot = this.m_146908_();
                this.setHorsePos(leftHorse, leftHorse.m_20182_().m_82549_(leftDisplace), yRot);
                this.setHorsePos(rightHorse, rightHorse.m_20182_().m_82549_(rightDisplace), yRot);
            }
        }
    }

    private void handleAcceleration() {
        double targetSpeed = this.speed * (double)this.speedLevel;
        if (this.isReversing()) {
            targetSpeed *= -0.25;
        }
        double accel = this.speed / (this.acceleration * 20.0);
        double speedDiff = targetSpeed - this.currentSpeed;
        this.currentSpeed += (double)Mth.m_14205_((double)speedDiff) * Math.min(Math.abs(accel), Math.abs(speedDiff));
    }

    private void setHorsePos(Mob horse, Vec3 pos, float rot) {
        if (horse == null) {
            return;
        }
        horse.m_146922_(rot);
        horse.m_5618_(rot);
        horse.m_5616_(rot);
        horse.m_146884_(pos);
    }

    private Vec3 collideSteering(Side side, float angle) {
        Vec3 collidedDisplacement;
        Vec3 local;
        Mob horse = this.getHorse(side);
        if (horse == null) {
            return Vec3.f_82478_;
        }
        Vec3 desired = this.rotateY(new Vec3(side == Side.LEFT ? -this.horseX : this.horseX, 0.0, this.horseY), this.m_146908_() + angle);
        Vec3 displacement = desired.m_82546_(local = horse.m_20182_().m_82546_(this.m_20182_()).m_82542_(1.0, 0.0, 1.0));
        if (!displacement.equals((Object)(collidedDisplacement = horse.m_20272_(displacement)).m_82542_(1.0, 0.0, 1.0))) {
            return Vec3.f_82478_;
        }
        return collidedDisplacement;
    }

    private float rotlerp(float angle, float target, float max) {
        float d = Mth.m_14177_((float)(target - angle));
        if (d > max) {
            d = max;
        }
        if (d < -max) {
            d = -max;
        }
        return angle + d;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.m_6084_()) {
            return InteractionResult.PASS;
        }
        boolean isClientSide = this.m_9236_().f_46443_;
        if (player.m_36341_()) {
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            if (stack.m_150930_((Item)TWItems.HORSE_WHIP.get())) {
                if (!isClientSide) {
                    this.toggleReversing();
                }
                return InteractionResult.m_19078_((boolean)isClientSide);
            }
            if (this.getHealth() < (float)this.maxHealth && stack.m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)ServerConfig.INSTANCE.repairItem.get())))) {
                if (!isClientSide) {
                    stack.m_41774_(1);
                    this.setHealth(this.getHealth() + (float)((Integer)ServerConfig.INSTANCE.repairPerItem.get()).intValue());
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11671_, SoundSource.MASTER, 0.3f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)isClientSide);
            }
            if (stack.m_204117_(ItemTags.f_271207_)) {
                if (!isClientSide && player.m_20148_().equals(this.owner)) {
                    this.onDestroyed(true);
                }
                return InteractionResult.m_19078_((boolean)isClientSide);
            }
            if (TrottingWagons.DYE_ITEMS.containsKey(item)) {
                this.setColor(TrottingWagons.DYE_ITEMS.get(item));
                return InteractionResult.m_19078_((boolean)isClientSide);
            }
            if (this.tryHitchHorse(player) || this.tryMountMob(player)) {
                return InteractionResult.m_19078_((boolean)isClientSide);
            }
            if (stack.m_150930_(Items.f_42655_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                for (Entity passenger : this.m_20197_()) {
                    if (!(passenger instanceof Mob)) continue;
                    Mob mob = (Mob)passenger;
                    mob.m_8127_();
                    player.m_21120_(hand).m_41774_(1);
                    if (!mob.m_6573_(player)) break;
                    mob.m_21463_((Entity)player, true);
                    break;
                }
                return InteractionResult.CONSUME;
            }
        } else if (player.m_20202_() != this) {
            if (!isClientSide) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean tryHitchHorse(Player player) {
        Mob horse = this.m_9236_().m_6443_(Mob.class, new AABB(player.m_20185_() - 7.0, player.m_20186_() - 7.0, player.m_20189_() - 7.0, player.m_20185_() + 7.0, player.m_20186_() + 7.0, player.m_20189_() + 7.0), h -> h.m_21524_() == player && ((List)ServerConfig.INSTANCE.allowedEntities.get()).contains(h.m_6095_().m_204041_().m_205785_().m_135782_().toString())).stream().findFirst().orElse(null);
        if (!this.m_9236_().f_46443_ && horse != null) {
            if (this.getHorse(Side.LEFT) == null) {
                this.hitchHorse(horse, Side.LEFT);
            } else if (this.getHorse(Side.RIGHT) == null) {
                this.hitchHorse(horse, Side.RIGHT);
            }
            horse.m_21455_(true, true);
        }
        return horse != null;
    }

    private boolean tryMountMob(Player player) {
        Mob mob = this.m_9236_().m_6443_(Mob.class, new AABB(player.m_20185_() - 7.0, player.m_20186_() - 7.0, player.m_20189_() - 7.0, player.m_20185_() + 7.0, player.m_20186_() + 7.0, player.m_20189_() + 7.0), h -> h.m_21524_() == player && !h.m_6095_().m_204039_(TrottingWagons.CANNOT_MOUNT_WAGON)).stream().findFirst().orElse(null);
        if (mob != null && !this.m_9236_().f_46443_ && this.m_7310_((Entity)mob)) {
            mob.m_20329_((Entity)this);
        }
        return mob != null;
    }

    private void hitchHorse(Mob horse, Side side) {
        this.setHorse(horse, side);
        this.initHorse(horse, side);
    }

    private void initHorse(Mob horse, Side side) {
        if (horse == null) {
            return;
        }
        horse.m_20153_();
        horse.m_20256_(Vec3.f_82478_);
        this.setHorsePos(horse, this.getHorsePos(side), this.m_146908_());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_12630_, SoundSource.MASTER);
        double w = this.m_20205_();
        double h = this.m_20206_();
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50741_.m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 100, w, h, w, 0.0);
        this.setHealth(this.getHealth() - amount);
        this.m_146852_(GameEvent.f_223706_, source.m_7639_());
        if (this.getHealth() <= 0.0f) {
            this.onDestroyed(false);
        }
        return true;
    }

    protected void onDestroyed(boolean dropItem) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Mob horse = this.getHorse(Side.LEFT);
        if (horse != null) {
            horse.m_21557_(false);
        }
        if ((horse = this.getHorse(Side.RIGHT)) != null) {
            horse.m_21557_(false);
        }
        this.m_20153_();
        this.m_146870_();
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        if (dropItem) {
            ItemStack pickResult = this.m_142340_();
            if (pickResult != null) {
                this.m_19983_(pickResult);
            }
        } else {
            this.m_19983_(new ItemStack((ItemLike)Items.f_42647_, RANDOM.nextInt(7)));
            this.m_19983_(new ItemStack((ItemLike)Items.f_42416_, RANDOM.nextInt(3)));
        }
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        double width = this.m_20205_();
        double offset = Math.sqrt(width * width + width * width) / 2.0 + 0.05;
        double pWidth = passenger.m_20205_();
        double pOffset = Math.sqrt(pWidth * pWidth + pWidth * pWidth) / 2.0;
        float yRot = this.m_146908_();
        Vec3 wOffset = new Vec3(0.0, (double)passenger.m_20192_(), 0.0);
        Vec3 pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(offset + pOffset, 0.0, 0.0), yRot));
        if (LevelUtils.isEmpty(this.m_9236_(), AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)(pWidth *= (double)0.8f), (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(-offset - pOffset, 0.0, 0.0), yRot));
        if (LevelUtils.isEmpty(this.m_9236_(), AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)pWidth, (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(0.0, 0.0, offset + pOffset), yRot));
        if (LevelUtils.isEmpty(this.m_9236_(), AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)pWidth, (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(0.0, 0.0, -offset - pOffset), yRot));
        if (LevelUtils.isEmpty(this.m_9236_(), AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)pWidth, (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        return super.m_7688_(passenger);
    }

    protected void m_8097_() {
        DyeColor color = this.getDefaultColor();
        this.f_19804_.m_135372_(DATA_ID_COLOR, (Object)(color != null ? OptionalInt.of(color.m_41060_()) : OptionalInt.empty()));
        this.f_19804_.m_135372_(DATA_ID_HEALTH, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(CompoundTag nbt) {
        if (nbt.m_128425_("color", 99)) {
            this.setColor(DyeColor.m_41053_((int)nbt.m_128451_("color")));
        }
        if (nbt.m_128441_("owner")) {
            this.owner = nbt.m_128342_("owner");
        }
        if (nbt.m_128441_("leftHorse")) {
            this.setHorseUUID(nbt.m_128342_("leftHorse"), Side.LEFT);
        }
        if (nbt.m_128441_("rightHorse")) {
            this.setHorseUUID(nbt.m_128342_("rightHorse"), Side.RIGHT);
        }
    }

    public void m_7380_(CompoundTag nbt) {
        if (this.getColor() != null) {
            nbt.m_128344_("color", (byte)this.getColor().m_41060_());
        }
        if (this.owner != null) {
            nbt.m_128362_("owner", this.owner);
        }
        if (this.getHorseUUID(Side.LEFT) != null) {
            nbt.m_128362_("leftHorse", this.getHorseUUID(Side.LEFT));
        }
        if (this.getHorseUUID(Side.RIGHT) != null) {
            nbt.m_128362_("rightHorse", this.getHorseUUID(Side.RIGHT));
        }
    }

    public void tryCycleSpeed(Player player) {
        if (player == this.m_6688_()) {
            this.speedLevel = (this.speedLevel + 1) % 3;
        }
    }

    private Mob getHorse(Side side) {
        EntityAccess entityAccess;
        UUID uuid = this.horseUuids[side.ordinal()];
        Mob horse = this.horses[side.ordinal()];
        if (uuid == null) {
            return null;
        }
        if (horse == null && (entityAccess = this.m_9236_().m_142646_().m_142694_(uuid)) instanceof Mob) {
            Mob mob;
            horse = mob = (Mob)entityAccess;
        }
        return horse != null && horse.m_6084_() ? horse : null;
    }

    private void setHorse(Mob horse, Side side) {
        Mob old = this.getHorse(side);
        if (old != null) {
            old.m_21557_(false);
        }
        if (horse != null) {
            horse.m_21557_(true);
        }
        this.horses[side.ordinal()] = horse;
        this.horseUuids[side.ordinal()] = horse != null ? horse.m_20148_() : null;
    }

    private UUID getHorseUUID(Side side) {
        return this.horseUuids[side.ordinal()];
    }

    private void setHorseUUID(UUID uuid, Side side) {
        this.horseUuids[side.ordinal()] = uuid;
    }

    private Vec3 getHorsePos(Side side) {
        return this.m_20182_().m_82549_(this.rotateY(new Vec3(side == Side.LEFT ? -this.horseX : this.horseX, 0.0, this.horseY), this.m_146908_()));
    }

    public float getShaftAngle() {
        return this.shaftAngle;
    }

    public DyeColor getColor() {
        OptionalInt i = (OptionalInt)this.f_19804_.m_135370_(DATA_ID_COLOR);
        return i.isPresent() ? DyeColor.m_41053_((int)i.getAsInt()) : null;
    }

    public void setColor(DyeColor color) {
        this.f_19804_.m_135381_(DATA_ID_COLOR, (Object)(color != null ? OptionalInt.of(color.m_41060_()) : OptionalInt.empty()));
    }

    protected DyeColor getDefaultColor() {
        return DyeColor.WHITE;
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_HEALTH)).floatValue();
    }

    protected void setHealth(float health) {
        this.f_19804_.m_135381_(DATA_ID_HEALTH, (Object)Float.valueOf(Mth.m_14036_((float)health, (float)0.0f, (float)this.maxHealth)));
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return !this.m_6095_().m_204039_(EntityTypeTags.f_273841_);
    }

    private static enum Side {
        LEFT,
        RIGHT;

    }
}

