/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.trotting_wagons.common.entities.base;

import net.favouriteless.trotting_wagons.common.entities.base.AbstractWagon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInventoryWagon
extends AbstractWagon
implements MenuProvider {
    private final NonNullList<ItemStack> inventory;
    private final ItemStackHandler itemHandler;
    private final LazyOptional<ItemStackHandler> itemHandlerOptional;

    public AbstractInventoryWagon(EntityType<? extends AbstractWagon> type, Level level, double wheelWidth, double wheelLength, Vec3[] riders, double speed, double acceleration, double turnRate, int maxHealth, double horseX, double horseY, float shaftAngle, int capacity) {
        super(type, level, wheelWidth, wheelLength, riders, speed, acceleration, turnRate, maxHealth, horseX, horseY, shaftAngle);
        this.inventory = NonNullList.m_122780_((int)capacity, (Object)ItemStack.f_41583_);
        this.itemHandler = new ItemStackHandler(this.inventory);
        this.itemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult superResult = super.m_6096_(player, hand);
        if (superResult != InteractionResult.PASS) {
            return superResult;
        }
        if (this.m_6084_() && !this.m_9236_().f_46443_ && player.m_36341_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeInt(this.m_19879_()));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.itemHandlerOptional.cast() : super.getCapability(cap, side);
    }

    @Override
    protected void onDestroyed(boolean dropItem) {
        super.onDestroyed(dropItem);
        if (!this.m_9236_().f_46443_) {
            Containers.m_19010_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), this.inventory);
        }
    }

    public ItemStackHandler getItems() {
        return this.itemHandler;
    }
}

