/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.trotting_wagons.common.entities.base;

import java.util.Iterator;
import net.favouriteless.trotting_wagons.client.TWClient;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractGeckolibVehicle
extends Entity
implements GeoEntity {
    private static final RawAnimation ANIM_MOVE = RawAnimation.begin().thenLoop("move.forwards");
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final double wheelWidth;
    private final double wheelLength;
    private final Vec3[] riders;
    private int lerpSteps = 0;
    private double lerpX = 0.0;
    private double lerpY = 0.0;
    private double lerpZ = 0.0;
    private double lerpXRot = 0.0;
    private double lerpYRot = 0.0;
    private boolean isReversing = false;
    private float wheelRot = 0.0f;
    private float wheelRotO = 0.0f;
    private float leftImpulse = 0.0f;

    public AbstractGeckolibVehicle(EntityType<?> type, Level level, double wheelWidth, double wheelLength, Vec3[] riders) {
        super(type, level);
        this.wheelWidth = wheelWidth;
        this.wheelLength = wheelLength;
        this.riders = riders;
    }

    public abstract void moveTick();

    public void m_8119_() {
        super.m_8119_();
        this.tickLerp();
        if (this.m_9236_().f_46443_ && this.m_6688_() == Minecraft.m_91087_().f_91074_) {
            TWClient.controlVehicle(this);
        }
        if (this.m_6109_()) {
            if (this.m_6688_() == null) {
                this.leftImpulse = 0.0f;
            }
            this.moveTick();
        }
        if (this.m_9236_().f_46443_) {
            this.wheelRotO = this.wheelRot;
            this.wheelRot += (float)this.m_20184_().m_165924_() * (this.isReversing ? -2.0f : 2.0f);
        }
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double f = 1.0 / (double)this.lerpSteps;
            double x = Mth.m_14139_((double)f, (double)this.m_20185_(), (double)this.lerpX);
            double y = Mth.m_14139_((double)f, (double)this.m_20186_(), (double)this.lerpY);
            double z = Mth.m_14139_((double)f, (double)this.m_20189_(), (double)this.lerpZ);
            float xRot = (float)Mth.m_14139_((double)f, (double)this.m_146909_(), (double)this.lerpXRot);
            float yRot = (float)Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_())) / (float)this.lerpSteps + this.m_146908_();
            --this.lerpSteps;
            this.m_6034_(x, y, z);
            this.m_19915_(yRot, xRot);
        }
    }

    protected float calculateTargetXRot() {
        Level level = this.m_9236_();
        Vec3 pos = this.m_20182_();
        double rayLength = this.wheelWidth * 2.0;
        float yaw = this.m_146908_();
        Vec3 fl = this.rotateY(-this.wheelWidth, 0.0, this.wheelLength, yaw).m_82549_(pos);
        Vec3 fr = this.rotateY(this.wheelWidth, 0.0, this.wheelLength, yaw).m_82549_(pos);
        Vec3 bl = this.rotateY(-this.wheelWidth, 0.0, -this.wheelLength, yaw).m_82549_(pos);
        Vec3 br = this.rotateY(this.wheelWidth, 0.0, -this.wheelLength, yaw).m_82549_(pos);
        BlockHitResult flr = level.m_45547_(new ClipContext(fl, fl.m_82492_(0.0, rayLength, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockHitResult frr = level.m_45547_(new ClipContext(fr, fr.m_82492_(0.0, rayLength, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockHitResult blr = level.m_45547_(new ClipContext(bl, bl.m_82492_(0.0, rayLength, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockHitResult brr = level.m_45547_(new ClipContext(br, br.m_82492_(0.0, rayLength, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        double fMax = Math.max(flr.m_82450_().f_82480_ - pos.f_82480_, frr.m_82450_().f_82480_ - pos.f_82480_);
        double bMax = Math.max(blr.m_82450_().f_82480_ - pos.f_82480_, brr.m_82450_().f_82480_ - pos.f_82480_);
        double xDiff = fMax - bMax;
        float f = (float)Mth.m_14008_((double)(xDiff / rayLength), (double)-1.0, (double)1.0);
        return f * -45.0f;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        Vec3 local = this.riders[this.getPassengerIndex(passenger)];
        Vec3 mid = new Vec3(0.0, 0.0, this.m_146909_() < 0.0f ? this.wheelLength : -this.wheelLength);
        local = local.m_82546_(mid);
        local = this.rotateX(local, this.m_146909_());
        local = local.m_82549_(mid);
        local = this.rotateY(local, this.m_146908_());
        local = local.m_82492_(0.0, 0.7, 0.0);
        callback.m_20372_(passenger, this.m_20185_() + local.f_82479_, this.m_20186_() + local.f_82480_, this.m_20189_() + local.f_82481_);
    }

    protected Vec3 rotateY(Vec3 pos, float angle) {
        return this.rotateY(pos.f_82479_, pos.f_82480_, pos.f_82481_, angle);
    }

    protected Vec3 rotateX(Vec3 pos, float angle) {
        return this.rotateX(pos.f_82479_, pos.f_82480_, pos.f_82481_, angle);
    }

    protected Vec3 rotateY(double x, double y, double z, float angle) {
        float a = angle * ((float)Math.PI / 180);
        float sin = Mth.m_14031_((float)a);
        float cos = Mth.m_14089_((float)a);
        return new Vec3(x * (double)cos - z * (double)sin, y, z * (double)cos + x * (double)sin);
    }

    protected Vec3 rotateX(double x, double y, double z, float angle) {
        float a = angle * ((float)Math.PI / 180);
        float sin = Mth.m_14031_((float)a);
        float cos = Mth.m_14089_((float)a);
        return new Vec3(x, y * (double)cos - z * (double)sin, z * (double)cos + y * (double)sin);
    }

    private int getPassengerIndex(Entity passenger) {
        Entity ent;
        int i = 0;
        Iterator iterator = this.m_20197_().iterator();
        while (iterator.hasNext() && (ent = (Entity)iterator.next()) != passenger) {
            ++i;
        }
        return i;
    }

    public float getXRot(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.f_19860_, (float)this.m_146909_());
    }

    public float getWheelRot(float partial) {
        return Mth.m_14179_((float)partial, (float)this.wheelRotO, (float)this.wheelRot);
    }

    protected float getSteeringImpulse() {
        return this.leftImpulse;
    }

    public void setSteeringImpulse(float impulse) {
        this.leftImpulse = impulse;
    }

    public double getWheelWidth() {
        return this.wheelWidth;
    }

    public double getWheelLength() {
        return this.wheelLength;
    }

    protected boolean isReversing() {
        return this.isReversing;
    }

    public void toggleReversing() {
        this.isReversing = !this.isReversing;
    }

    public LivingEntity m_6688_() {
        return !this.m_20197_().isEmpty() ? (LivingEntity)this.m_20197_().get(0) : null;
    }

    protected boolean m_7310_(Entity passenger) {
        return passenger instanceof LivingEntity && this.m_20197_().size() < this.riders.length;
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int steps, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = steps;
    }

    public boolean m_5829_() {
        return true;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public boolean m_6087_() {
        return true;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, vehicle -> {
            if (this.m_20184_().m_165924_() > (double)0.01f) {
                return vehicle.setAndContinue(ANIM_MOVE);
            }
            return PlayState.STOP;
        })});
    }
}

