/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.trotting_wagons.client.render.entity;

import net.favouriteless.trotting_wagons.TrottingWagons;
import net.favouriteless.trotting_wagons.common.entities.base.AbstractGeckolibVehicle;
import net.favouriteless.trotting_wagons.common.entities.base.AbstractWagon;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.DyeColor;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class WagonModel<T extends AbstractWagon>
extends DefaultedEntityGeoModel<T> {
    private final String texturePathPrefix;

    public WagonModel(ResourceLocation assetSubpath) {
        super(assetSubpath, false);
        this.texturePathPrefix = "textures/entity/" + assetSubpath.m_135815_() + "/";
    }

    public ResourceLocation getTextureResource(T wagon) {
        DyeColor color = ((AbstractWagon)((Object)wagon)).getColor();
        return TrottingWagons.id(this.texturePathPrefix + (color != null ? color.m_41065_() : "none") + ".png");
    }

    public void setCustomAnimations(T wagon, long instanceId, AnimationState<T> state) {
        super.setCustomAnimations(wagon, instanceId, state);
        AnimationProcessor processor = this.getAnimationProcessor();
        float partialTick = (float)state.animationTick - (float)((int)state.animationTick);
        float rot = ((AbstractGeckolibVehicle)((Object)wagon)).getWheelRot(partialTick);
        processor.getBone("FrontWheels").setRotX(-rot);
        processor.getBone("RearWheels").setRotX(-rot);
        if (!wagon.m_9236_().m_6443_(Mob.class, wagon.m_20191_().m_82400_(10.0), Mob::m_21525_).isEmpty()) {
            processor.getBone("Tongue").setRotX(((AbstractWagon)((Object)wagon)).getShaftAngle() * ((float)Math.PI / 180));
        }
    }
}

