/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.trotting_wagons;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ServerConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedEntities;
    public final ForgeConfigSpec.ConfigValue<String> repairItem;
    public final ForgeConfigSpec.IntValue repairPerItem;
    public final ForgeConfigSpec.IntValue conestogaHealth;
    public final ForgeConfigSpec.DoubleValue conestogaSpeed;
    public final ForgeConfigSpec.DoubleValue conestogaAcceleration;
    public final ForgeConfigSpec.DoubleValue conestogaTurnRate;
    public final ForgeConfigSpec.IntValue royalHealth;
    public final ForgeConfigSpec.DoubleValue royalSpeed;
    public final ForgeConfigSpec.DoubleValue royalAcceleration;
    public final ForgeConfigSpec.DoubleValue royalTurnRate;
    public final ForgeConfigSpec.IntValue armoredHealth;
    public final ForgeConfigSpec.DoubleValue armoredSpeed;
    public final ForgeConfigSpec.DoubleValue armoredAcceleration;
    public final ForgeConfigSpec.DoubleValue armoredTurnRate;

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        this.allowedEntities = builder.comment("EntityTypes allowed to pull wagons").defineList("allowed_entities", List.of("minecraft:horse"), e -> true);
        this.repairItem = builder.comment("ID of the item (or tag, if starting with #) used to repair wagons").define("repair_material", (Object)"minecraft:iron_ingot");
        this.repairPerItem = builder.comment("The amount of durability regained per repair item.").defineInRange("repair_value", 10, 0, Integer.MAX_VALUE);
        builder.push("Conestoga Wagon Options");
        this.conestogaHealth = builder.comment("Maximum health").defineInRange("conestoga_wagon_health", 60, 0, Integer.MAX_VALUE);
        this.conestogaSpeed = builder.comment("Speed (per level)").defineInRange("conestoga_wagon_speed", 0.1, 0.0, Double.MAX_VALUE);
        this.conestogaAcceleration = builder.comment("Acceleration (seconds until maximum speed)").defineInRange("conestoga_wagon_acceleration", 2.0, 0.0, Double.MAX_VALUE);
        this.conestogaTurnRate = builder.comment("Turn rate").defineInRange("conestoga_wagon_turn_rate", 2.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("Royal Wagon Options");
        this.royalHealth = builder.comment("Maximum health").defineInRange("royal_wagon_health", 80, 0, Integer.MAX_VALUE);
        this.royalSpeed = builder.comment("Speed (per level)").defineInRange("royal_wagon_speed", 0.15, 0.0, Double.MAX_VALUE);
        this.royalAcceleration = builder.comment("Acceleration (seconds until maximum speed)").defineInRange("royal_wagon_acceleration", 3.0, 0.0, Double.MAX_VALUE);
        this.royalTurnRate = builder.comment("Turn rate").defineInRange("royal_wagon_turn_rate", 2.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("Armored Wagon Options");
        this.armoredHealth = builder.comment("Maximum health").defineInRange("armored_wagon_health", 120, 0, Integer.MAX_VALUE);
        this.armoredSpeed = builder.comment("Speed (per level)").defineInRange("armored_wagon_speed", 0.1, 0.0, Double.MAX_VALUE);
        this.armoredAcceleration = builder.comment("Acceleration (seconds until maximum speed)").defineInRange("armored_wagon_acceleration", 4.0, 0.0, Double.MAX_VALUE);
        this.armoredTurnRate = builder.comment("Turn rate").defineInRange("armored_wagon_turn_rate", 2.0, 0.0, Double.MAX_VALUE);
        builder.pop();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        INSTANCE = (ServerConfig)pair.getLeft();
        SPEC = (ForgeConfigSpec)pair.getRight();
    }
}

