/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NBTListCodec<ENTRY, RAW> {
    private final String name;
    private final ListTagType<RAW> type;
    private final Function<ENTRY, Tag> elementWriter;
    private final Function<RAW, ENTRY> elementReader;

    public NBTListCodec(String name, ListTagType<RAW> type, Function<ENTRY, RAW> elementWriter, Function<RAW, ENTRY> elementReader) {
        this.name = name;
        this.type = type;
        this.elementWriter = elementWriter.andThen(this.type.serializer);
        this.elementReader = elementReader;
    }

    public List<ENTRY> read(CompoundTag compound) {
        ArrayList newList = new ArrayList();
        ListTag listTag = compound.m_128437_(this.name, this.type.tagID);
        if (listTag == null) {
            return newList;
        }
        int listSize = listTag.size();
        if (listSize <= 0) {
            return newList;
        }
        IntStream.range(0, listSize).mapToObj(i -> this.type.listReader.apply(listTag, i)).forEach(nbt -> newList.add(this.elementReader.apply(nbt)));
        return newList;
    }

    public CompoundTag write(List<ENTRY> list, CompoundTag compound) {
        ListTag nbtList = new ListTag();
        list.forEach(element -> nbtList.add((Object)this.elementWriter.apply(element)));
        compound.m_128365_(this.name, (Tag)nbtList);
        return compound;
    }

    public static class ListTagType<T> {
        public static final ListTagType<Byte> BYTE = new ListTagType<Byte>(1, (list, i) -> (byte)list.m_128763_(i), ByteTag::m_128266_);
        public static final ListTagType<Short> SHORT = new ListTagType<Short>(2, ListTag::m_128757_, ShortTag::m_129258_);
        public static final ListTagType<Integer> INTEGER = new ListTagType<Integer>(3, ListTag::m_128763_, IntTag::m_128679_);
        public static final ListTagType<Float> FLOAT = new ListTagType<Float>(5, ListTag::m_128775_, FloatTag::m_128566_);
        public static final ListTagType<Double> DOUBLE = new ListTagType<Double>(6, ListTag::m_128772_, DoubleTag::m_128500_);
        public static final ListTagType<String> STRING = new ListTagType<String>(8, ListTag::m_128778_, StringTag::m_129297_);
        public static final ListTagType<ListTag> LIST = new ListTagType<ListTag>(9, ListTag::m_128744_, x -> x);
        public static final ListTagType<CompoundTag> COMPOUND = new ListTagType<CompoundTag>(10, ListTag::m_128728_, x -> x);
        final int tagID;
        final ListReader<T> listReader;
        final Function<T, Tag> serializer;

        public ListTagType(int tagID, ListReader<T> listReader, Function<T, Tag> serializer) {
            this.tagID = tagID;
            this.listReader = listReader;
            this.serializer = serializer;
        }
    }

    @FunctionalInterface
    public static interface ListReader<T> {
        public T apply(ListTag var1, int var2);
    }
}

