/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.create_better_motors.content.alternator.blocksentity;

import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.reggarf.mods.create_better_motors.config.CommonConfig;
import com.reggarf.mods.create_better_motors.registry.CBMBlocks;
import com.reggarf.mods.create_better_motors.util.StringFormattingTool;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class AndesiteAlternatorBlockEntity
extends KineticBlockEntity {
    protected final InternalEnergyStorage energy;
    private LazyOptional<IEnergyStorage> lazyEnergy;
    private boolean firstTickState = true;
    private LazyOptional<IEnergyStorage> escacheUp = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheDown = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheNorth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheEast = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheSouth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheWest = LazyOptional.empty();

    public AndesiteAlternatorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.energy = new InternalEnergyStorage(((Integer)CommonConfig.ANDESITE_ALTERNATOR_CAPACITY.get()).intValue(), 0, ((Integer)CommonConfig.ANDESITE_ALTERNATOR_MAX_OUTPUT.get()).intValue());
        this.lazyEnergy = LazyOptional.of(() -> this.energy);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_better_motors.generating", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_output", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_per_tick", (Object[])new Object[]{StringFormattingTool.formatLong(AndesiteAlternatorBlockEntity.getEnergyProductionRate((int)this.getSpeed()))}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_stored", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_storage", (Object[])new Object[]{StringFormattingTool.formatLong(this.energy.getEnergyStored()), StringFormattingTool.formatLong(this.energy.getMaxEnergyStored())}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isEnergyInput(Direction side) {
        return false;
    }

    public boolean isEnergyOutput(Direction side) {
        return true;
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.energy.read(compound);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        if (Math.abs(this.getSpeed()) > 0.0f && this.isSpeedRequirementFulfilled()) {
            this.energy.internalProduceEnergy(AndesiteAlternatorBlockEntity.getEnergyProductionRate((int)this.getSpeed()));
        }
        for (Direction d : Direction.values()) {
            IEnergyStorage ies;
            if (!this.isEnergyOutput(d) || (ies = this.getCachedEnergy(d)) == null) continue;
            int ext = this.energy.extractEnergy(ies.receiveEnergy(((Integer)CommonConfig.ANDESITE_ALTERNATOR_MAX_OUTPUT.get()).intValue(), true), false);
            ies.receiveEnergy(ext, false);
        }
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)((Integer)CommonConfig.ANDESITE_ALTERNATOR_MAX_STRESS.get()).intValue() / 256.0f;
        return impact;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        float componentSpeed = Math.abs(this.getSpeed());
        if (componentSpeed == 0.0f || !this.isSpeedRequirementFulfilled()) {
            return;
        }
        float pitch = Mth.m_14036_((float)(componentSpeed / 256.0f + 0.5f), (float)0.5f, (float)1.5f);
        if (((Boolean)CommonConfig.ANDESITE_ALTERNATOR_AUDIO_ENABLED.get()).booleanValue()) {
            CASoundScapes.play((CASoundScapes.AmbienceGroup)CASoundScapes.AmbienceGroup.DYNAMO, (BlockPos)this.f_58858_, (float)pitch);
        }
    }

    public static int getEnergyProductionRate(int rpm) {
        rpm = Math.abs(rpm);
        return (int)((double)((Integer)CommonConfig.ANDESITE_ALTERNATOR_FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0) * (Double)CommonConfig.ANDESITE_ALTERNATOR_EFFICIENCY.get());
    }

    protected Block getStressConfigKey() {
        return (Block)CBMBlocks.ANDESITE_ALTERNATOR.get();
    }

    public void remove() {
        this.lazyEnergy.invalidate();
        super.remove();
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        for (Direction side : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
            if (te == null) {
                this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
                continue;
            }
            LazyOptional le = te.getCapability(ForgeCapabilities.ENERGY, side.m_122424_());
            this.setCache(side, (LazyOptional<IEnergyStorage>)le);
        }
    }

    public void setCache(Direction side, LazyOptional<IEnergyStorage> storage) {
        switch (side) {
            case DOWN: {
                this.escacheDown = storage;
                break;
            }
            case EAST: {
                this.escacheEast = storage;
                break;
            }
            case NORTH: {
                this.escacheNorth = storage;
                break;
            }
            case SOUTH: {
                this.escacheSouth = storage;
                break;
            }
            case UP: {
                this.escacheUp = storage;
                break;
            }
            case WEST: {
                this.escacheWest = storage;
            }
        }
    }

    public IEnergyStorage getCachedEnergy(Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> (IEnergyStorage)this.escacheDown.orElse(null);
            case Direction.EAST -> (IEnergyStorage)this.escacheEast.orElse(null);
            case Direction.NORTH -> (IEnergyStorage)this.escacheNorth.orElse(null);
            case Direction.SOUTH -> (IEnergyStorage)this.escacheSouth.orElse(null);
            case Direction.UP -> (IEnergyStorage)this.escacheUp.orElse(null);
            case Direction.WEST -> (IEnergyStorage)this.escacheWest.orElse(null);
        };
    }
}

