/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.breezy.client;

import codyhuh.breezy.client.render.HotAirBalloonRenderer;
import codyhuh.breezy.common.network.BreezyNetworking;
import codyhuh.breezy.common.network.NewWindSavedData;
import codyhuh.breezy.core.other.util.WindMathUtil;
import codyhuh.breezy.core.registry.BreezyEntities;
import codyhuh.breezy.core.registry.BreezyItems;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="breezy", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer((EntityType)BreezyEntities.HOT_AIR_BALLOON.get(), HotAirBalloonRenderer::new);
    }

    @SubscribeEvent
    public static void registerClient(FMLClientSetupEvent e) {
        ItemProperties.register((Item)((Item)BreezyItems.GUST_GAUGE.get()), (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            private final CompassWobble wobble = new CompassWobble();
            private final CompassWobble wobbleRandom = new CompassWobble();

            public float m_142187_(ItemStack stack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int p_174675_) {
                long i;
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : stack.m_41609_();
                if (entity == null) {
                    return 0.0f;
                }
                if (clientLevel == null && entity.m_9236_() instanceof ClientLevel) {
                    clientLevel = (ClientLevel)entity.m_9236_();
                }
                NewWindSavedData data = BreezyNetworking.CLIENT_CACHE;
                long l = i = clientLevel != null ? clientLevel.m_46467_() : 0L;
                if (data != null) {
                    double d3;
                    Player player;
                    double direction = data.getWindAtHeight(entity.m_20183_().m_123342_(), entity.m_9236_());
                    boolean flag = livingEntity instanceof Player && (player = (Player)livingEntity).m_7578_();
                    double d1 = 0.0;
                    if (flag) {
                        d1 = livingEntity.m_146908_();
                    } else if (entity instanceof ItemFrame) {
                        d1 = this.getFrameRotation((ItemFrame)entity);
                    } else if (entity instanceof ItemEntity) {
                        d1 = 180.0f - ((ItemEntity)entity).m_32008_(0.5f) / ((float)Math.PI * 2) * 360.0f;
                    } else if (livingEntity != null) {
                        d1 = livingEntity.f_20883_;
                    }
                    d1 = Mth.m_14109_((double)(d1 / 360.0), (double)1.0);
                    double d2 = this.getAngleTo(new Vec3(WindMathUtil.stepX(direction), 0.0, WindMathUtil.stepZ(direction)).m_82490_(Double.MAX_VALUE), (Entity)entity) / 6.2831854820251465;
                    if (flag) {
                        if (this.wobble.shouldUpdate(i)) {
                            this.wobble.update(i, 0.5 - (d1 - 0.25));
                        }
                        d3 = d2 + this.wobble.rotation;
                    } else {
                        d3 = 0.5 - (d1 - 0.25 - d2);
                    }
                    return Mth.m_14091_((float)((float)d3), (float)1.0f);
                }
                if (this.wobbleRandom.shouldUpdate(i)) {
                    this.wobbleRandom.update(i, Math.random());
                }
                double d0 = this.wobbleRandom.rotation + (double)((float)this.hash(p_174675_) / 2.1474836E9f);
                return Mth.m_14091_((float)((float)d0), (float)1.0f);
            }

            private int hash(int p_174670_) {
                return p_174670_ * 1327217883;
            }

            private double getFrameRotation(ItemFrame p_117914_) {
                Direction direction = p_117914_.m_6350_();
                int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
                return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + p_117914_.m_31823_() * 45 + i));
            }

            private double getAngleTo(Vec3 p_117919_, Entity p_117920_) {
                return Math.atan2(p_117919_.m_7094_() - p_117920_.m_20189_(), p_117919_.m_7096_() - p_117920_.m_20185_());
            }
        });
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.getItemColors().m_92689_((stack, color) -> color > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)BreezyItems.HOT_AIR_BALLOON.get()});
    }

    private static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        private CompassWobble() {
        }

        boolean shouldUpdate(long p_117934_) {
            return this.lastUpdateTick != p_117934_;
        }

        void update(long p_117936_, double p_117937_) {
            this.lastUpdateTick = p_117936_;
            double d0 = p_117937_ - this.rotation;
            d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

