/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.breezy;

import codyhuh.breezy.BreezyConfig;
import codyhuh.breezy.common.entity.HotAirBalloonEntity;
import codyhuh.breezy.common.network.BreezyNetworking;
import codyhuh.breezy.common.network.NewWindSavedData;
import codyhuh.breezy.common.network.WindDirectionPacket;
import codyhuh.breezy.core.data.server.BreezyBiomeTagsProvider;
import codyhuh.breezy.core.data.server.BreezyEntityTypeTagsProvider;
import codyhuh.breezy.core.other.tags.BreezyItemTags;
import codyhuh.breezy.core.other.util.HitBoxUtil;
import codyhuh.breezy.core.registry.BreezyEntities;
import codyhuh.breezy.core.registry.BreezyItems;
import codyhuh.breezy.core.registry.BreezyParticles;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Vec3i;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="breezy")
public class Breezy {
    public static final String MOD_ID = "breezy";
    public static final Logger LOGGER = LogManager.getLogger();

    public Breezy() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        ModLoadingContext context = ModLoadingContext.get();
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::registerEntityAttributes);
        bus.addListener(this::populateTabs);
        forgeBus.addListener(this::resetWindDirection);
        forgeBus.addListener(this::syncWindDataOnJoinWorld);
        forgeBus.addListener(this::tntDrop);
        BreezyParticles.PARTICLES.register(bus);
        BreezyEntities.ENTITIES.register(bus);
        BreezyItems.ITEMS.register(bus);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BreezyConfig.COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BreezyConfig.CLIENT_SPEC);
    }

    private void populateTabs(BuildCreativeModeTabContentsEvent e) {
        if (e.getTabKey() == CreativeModeTabs.f_256869_) {
            for (RegistryObject item : BreezyItems.ITEMS.getEntries()) {
                e.m_246326_((ItemLike)item.get());
            }
        }
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent e) {
        e.put((EntityType)BreezyEntities.HOT_AIR_BALLOON.get(), HotAirBalloonEntity.createAttributes().m_22265_());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BreezyNetworking.register();
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        generator.addProvider(server, (DataProvider)new BreezyBiomeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new BreezyEntityTypeTagsProvider(output, provider, helper));
    }

    private void resetWindDirection(TickEvent.LevelTickEvent e) {
        Level world = e.level;
        if (!world.f_46443_ && world.m_46467_() % (long)((Integer)BreezyConfig.COMMON.windPeriodLength.get()).intValue() == 0L) {
            NewWindSavedData.resetWindDirections((Integer)BreezyConfig.COMMON.windPeriodLength.get(), (Double)BreezyConfig.COMMON.changePercentage.get());
            world.m_6907_().forEach(player -> {
                Level level = player.m_9236_();
                if (level.f_46443_) {
                    return;
                }
                NewWindSavedData data = (NewWindSavedData)((ServerLevel)level).m_8895_().m_164861_(NewWindSavedData::new, () -> new NewWindSavedData(((ServerLevel)level).m_7328_()), "breezy.savedata");
                BreezyNetworking.sendToPlayer(new WindDirectionPacket(data), (ServerPlayer)player);
            });
        }
    }

    public void syncWindDataOnJoinWorld(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!e.getLevel().f_46443_) {
                NewWindSavedData data = (NewWindSavedData)((ServerLevel)player.m_9236_()).m_8895_().m_164861_(NewWindSavedData::new, () -> new NewWindSavedData(((ServerLevel)player.m_9236_()).m_7328_()), "breezy.savedata");
                BreezyNetworking.sendToPlayer(new WindDirectionPacket(data), (ServerPlayer)player);
            }
        }
    }

    public void tntDrop(PlayerInteractEvent.RightClickItem event) {
        HotAirBalloonEntity balloon;
        Entity stack2;
        Player player = event.getEntity();
        ItemStack pen = ItemStack.f_41583_;
        ItemStack pineapple = ItemStack.f_41583_;
        for (Entity stack2 : player.m_6167_()) {
            if (stack2.m_204117_(BreezyItemTags.IGNITION_SOURCES)) {
                pen = stack2;
            }
            if (!stack2.m_150930_(Items.f_41996_)) continue;
            pineapple = stack2;
        }
        stack2 = player.m_20202_();
        if (stack2 instanceof HotAirBalloonEntity && !(balloon = (HotAirBalloonEntity)stack2).m_20096_() && HitBoxUtil.isNotAimingAtHitbox((Entity)player, HitBoxUtil.boxInLevel(HotAirBalloonEntity.BALLOON_AABB, (Entity)balloon), player.m_20252_((float)player.getEntityReach())) && !pen.m_41619_() && !pineapple.m_41619_()) {
            Level level = event.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                PrimedTnt tnt = (PrimedTnt)EntityType.f_20515_.m_20615_(event.getLevel());
                if (tnt != null) {
                    tnt.m_20219_(Vec3.m_82539_((Vec3i)player.m_20183_().m_7494_()));
                    server.m_7967_((Entity)tnt);
                    balloon.m_5496_(SoundEvents.f_11942_, 1.0f, 1.0f);
                    if (!player.m_150110_().f_35937_) {
                        pineapple.m_41774_(1);
                        pen.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    }
                }
            } else {
                player.m_6674_(event.getHand());
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }
}

