/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stoneworks.world.block.variant;

import fuzs.stoneworks.world.block.variant.BlockVariant;
import java.util.Locale;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum StoneType {
    STONE(Blocks.f_50069_),
    ANDESITE(Blocks.f_50334_),
    GRANITE(Blocks.f_50122_),
    DIORITE(Blocks.f_50228_),
    DEEPSLATE(Blocks.f_152550_),
    CALCITE(Blocks.f_152497_),
    TUFF(Blocks.f_152496_),
    BASALT(Blocks.f_50137_),
    BLACKSTONE(Blocks.f_50730_),
    NETHERRACK(Blocks.f_50134_, false){

        @Override
        public Block getBaseBlock(BlockVariant blockVariant) {
            if (blockVariant.usesNetherbricksMaterial()) {
                return Blocks.f_50197_;
            }
            return super.getBaseBlock(blockVariant);
        }

        @Override
        public String getName(BlockVariant blockVariant) {
            if (blockVariant.usesNetherbricksMaterial()) {
                return "nether_brick";
            }
            return super.getName(blockVariant);
        }
    }
    ,
    END_STONE(Blocks.f_50259_, false),
    PURPUR(Blocks.f_50492_, false),
    PRISMARINE(Blocks.f_50377_, false),
    DARK_PRISMARINE(Blocks.f_50379_, false),
    SANDSTONE(Blocks.f_50062_, false),
    RED_SANDSTONE(Blocks.f_50394_, false),
    QUARTZ(Blocks.f_50333_, false);

    private final Block baseBlock;
    private final boolean isCobbleHardened;

    private StoneType(Block baseBlock) {
        this(baseBlock, true);
    }

    private StoneType(Block baseBlock, boolean isCobbleHardened) {
        this.baseBlock = baseBlock;
        this.isCobbleHardened = isCobbleHardened;
    }

    public Block getBaseBlock(BlockVariant blockVariant) {
        return this.baseBlock;
    }

    public BlockState getDefaultBlockState(BlockVariant blockVariant) {
        return this.getBaseBlock(blockVariant).m_49966_();
    }

    protected BlockBehaviour.Properties getBlockProperties(BlockVariant blockVariant) {
        Block baseBlock = this.getBaseBlock(blockVariant);
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)baseBlock);
        if (this.isCobbleHardened && blockVariant != BlockVariant.REGULAR) {
            properties.m_60913_(baseBlock.m_155943_() + 0.5f, baseBlock.m_7325_());
        }
        return properties;
    }

    public String getName(BlockVariant blockVariant) {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean hasChiseledMotif() {
        return this == DIORITE || this == DEEPSLATE || this == CALCITE || this == TUFF || this == BLACKSTONE || this == NETHERRACK || this == PRISMARINE || this == DARK_PRISMARINE || this == SANDSTONE || this == RED_SANDSTONE;
    }
}

