/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.curio;

import appeng.menu.locator.MenuLocator;
import de.mari_023.ae2wtlib.curio.CurioLocator;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public final class CurioHelper {
    private CurioHelper() {
    }

    public static boolean isStillPresent(Player player, ItemStack terminal) {
        List slotResults = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, terminal.m_41720_());
        for (SlotResult slotResult : slotResults) {
            if (!slotResult.stack().equals(terminal)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getItemStack(Player player, MenuLocator locator) {
        if (locator instanceof CurioLocator) {
            CurioLocator curioLocator = (CurioLocator)locator;
            return curioLocator.locateItem(player);
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public static MenuLocator findTerminal(Player player, String terminalName) {
        Optional slotResult = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, stack -> WUTHandler.hasTerminal(stack, terminalName));
        if (slotResult.isPresent() && ((SlotResult)slotResult.get()).slotContext() != null) {
            return new CurioLocator(((SlotResult)slotResult.get()).slotContext());
        }
        return null;
    }

    public static void addAllCurios(List<ItemStack> items, Player player) {
        List inventory = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, stack -> true);
        for (SlotResult slotResult : inventory) {
            items.add(slotResult.stack());
        }
    }
}

