/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.ArrayUtils;

public class Utils {
    public static Supplier<Level> CLIENT_LEVEL_SUPPLIER = () -> null;
    public static Supplier<Player> CLIENT_PLAYER_SUPPLIER = () -> null;
    private static final Direction[][] ROTATION_PLANES = new Direction[][]{{Direction.DOWN, Direction.SOUTH, Direction.UP, Direction.NORTH}, {Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST}, {Direction.DOWN, Direction.WEST, Direction.UP, Direction.EAST}};

    public static Player getClientPlayer() {
        return CLIENT_PLAYER_SUPPLIER.get();
    }

    public static Level getClientLevel() {
        return CLIENT_LEVEL_SUPPLIER.get();
    }

    public static byte set(byte value, int position, boolean state) {
        if (state) {
            return (byte)(value | 1 << position);
        }
        return (byte)(value & ~(1 << position));
    }

    public static <T> T cycle(T[] arr, T current) {
        int currentIdx = ArrayUtils.indexOf((Object[])arr, current);
        int idx = (currentIdx + 1) % arr.length;
        return arr[idx];
    }

    public static <T> T cycleConditionally(T[] arr, T current, Predicate<T> predicate) {
        int currentIdx = ArrayUtils.indexOf((Object[])arr, current);
        for (int i = 0; i < arr.length - 1; ++i) {
            int idx = (currentIdx + i + 1) % arr.length;
            T candidate = arr[idx];
            if (!predicate.test(candidate)) continue;
            return candidate;
        }
        return current;
    }

    public static <T> T[] rotateArray(T[] arr, Rotation rotation) {
        T[] newArr = Arrays.copyOf(arr, arr.length);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            newArr[rotation.m_55954_((Direction)direction).ordinal()] = arr[direction.ordinal()];
        }
        return newArr;
    }

    public static int[] rotateArray(int[] arr, Rotation rotation) {
        int[] newArr = Arrays.copyOf(arr, arr.length);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            newArr[rotation.m_55954_((Direction)direction).ordinal()] = arr[direction.ordinal()];
        }
        return newArr;
    }

    public static BlockState resolveHit(BlockGetter level, BlockHitResult hit) {
        return level.m_8055_(hit.m_82425_());
    }

    public static <T> Set<T> newIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newFilledEnumMap(Class<K> keyType, Function<K, V> valueMapper) {
        EnumMap<Enum, V> map = new EnumMap<Enum, V>(keyType);
        for (Enum key : (Enum[])keyType.getEnumConstants()) {
            map.put(key, valueMapper.apply(key));
        }
        return map;
    }

    public static <T> List<T> newFilledList(int size, Supplier<T> entryFactory) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            list.add(entryFactory.get());
        }
        return list;
    }

    public static <T> List<T> newFilledList(int size, IntFunction<T> entryFactory) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            list.add(entryFactory.apply(i));
        }
        return list;
    }

    public static ItemEntity dropItemAt(Level level, BlockPos pos, ItemStack stack) {
        ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
        level.m_7967_((Entity)entity);
        return entity;
    }

    public static ItemEntity dropItemOutwardsAtSide(Level level, BlockPos pos, Direction side, ItemStack stack) {
        ItemEntity entity = new ItemEntity(level, (double)((float)pos.m_123341_() + ((float)side.m_122429_() * 1.5f + 1.0f) / 2.0f), (double)((float)pos.m_123342_() + ((float)side.m_122430_() * 1.5f + 1.0f) / 2.0f), (double)((float)pos.m_123343_() + ((float)side.m_122431_() * 1.5f + 1.0f) / 2.0f), stack, (double)((float)side.m_122429_() * 0.2f + level.f_46441_.m_188501_() * 0.1f - 0.05f), (double)((float)side.m_122430_() * 0.2f + level.f_46441_.m_188501_() * 0.1f - 0.05f), (double)((float)side.m_122431_() * 0.2f + level.f_46441_.m_188501_() * 0.1f - 0.05f));
        level.m_7967_((Entity)entity);
        return entity;
    }

    @Nullable
    public static <T> TagKey<T> loadTagKey(CompoundTag tag, Function<ResourceLocation, TagKey<T>> factory) {
        String string = tag.m_128461_("tag");
        if (string.isEmpty()) {
            return null;
        }
        return factory.apply(new ResourceLocation(string));
    }

    @Nullable
    public static Direction.AxisDirection getAxisDirection(int value) {
        if (value == 0) {
            return null;
        }
        return value > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
    }

    @Nullable
    public static Direction getDirection(Vec3i vector) {
        int x = vector.m_123341_();
        int y = vector.m_123342_();
        int z = vector.m_123343_();
        if (x * y == x + y) {
            Direction.AxisDirection axisDirection = Utils.getAxisDirection(vector.m_123343_());
            return axisDirection != null ? Direction.m_122387_((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)axisDirection) : null;
        }
        if (x * z == x + z) {
            Direction.AxisDirection axisDirection = Utils.getAxisDirection(y);
            return axisDirection != null ? Direction.m_122387_((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)axisDirection) : null;
        }
        if (y * z == y + z) {
            Direction.AxisDirection axisDirection = Utils.getAxisDirection(x);
            return axisDirection != null ? Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)axisDirection) : null;
        }
        return null;
    }

    public static Direction rotate(Direction direction, Direction.Axis axis, Rotation rotation) {
        if (axis == direction.m_122434_()) {
            return direction;
        }
        List<Direction> plane = Arrays.asList(ROTATION_PLANES[axis.ordinal()]);
        int currentIndex = plane.indexOf(direction);
        int newIndex = rotation.m_55949_(currentIndex, plane.size());
        return plane.get(newIndex);
    }
}

