/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public final class FakePlayerUtils {
    public static UUID DEFAULT_UUID = UUID.fromString("36b3ed1e-2c1b-11ee-be56-0242ac120002");
    private static final WeakHashMap<Level, FakePlayer> FAKE_PLAYERS = new WeakHashMap();

    private FakePlayerUtils() {
    }

    static Player get(ServerLevel level, GameProfile profile) {
        Objects.requireNonNull(level);
        FakePlayer wrp = FAKE_PLAYERS.get(level);
        if (wrp != null) {
            return wrp;
        }
        FakePlayer p = new FakePlayer(level, profile);
        FAKE_PLAYERS.put((Level)level, p);
        return p;
    }

    public static Player getFakePlayer(ServerLevel level) {
        return FakePlayerUtils.getFakePlayer(level, null);
    }

    public static Player getFakePlayer(ServerLevel level, @Nullable UUID playerUuid) {
        Objects.requireNonNull(level);
        if (playerUuid == null) {
            playerUuid = DEFAULT_UUID;
        }
        return FakePlayerUtils.get(level, new GameProfile(playerUuid, "[XyCraft]"));
    }
}

