/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.MapColor;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import tv.soaryn.xycraft.core.content.CustomColors;

public class ColorUtils {
    public static int getColorFromDyeNoCorrection(DyeColor color) {
        float[] rgbFloats = color.m_41068_();
        return 0xFF000000 | (int)(rgbFloats[0] * 255.0f) << 16 | (int)(rgbFloats[1] * 255.0f) << 8 | (int)(rgbFloats[2] * 255.0f);
    }

    public static int getColorFromDye(DyeColor color) {
        float[] rgbFloats = color.m_41068_();
        Vector3f rgb = new Vector3f(rgbFloats[0], rgbFloats[1], rgbFloats[2]);
        if (color == DyeColor.LIGHT_BLUE) {
            return -10318081;
        }
        return ColorUtils.convertComponentsToRGB(rgb);
    }

    public static int getColorTime(int offset) {
        return ColorUtils.getColorTime(offset, 10000);
    }

    public static int getColorTime(int offset, int speed) {
        return ColorUtils.HSBtoRGB((float)((System.currentTimeMillis() + (long)offset) % (long)speed) / (float)speed, 1.0f, 1.0f);
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static Vector3f convertRGBToComponents(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Vector3f(r, g, b);
    }

    public static Vector4f convertRGBAToComponents(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Vector4f(r, g, b, a);
    }

    public static int convertComponentsToRGB(Vector3f rgb) {
        return 0xFF000000 | (int)(rgb.x * 255.0f) << 16 | (int)(rgb.y * 255.0f) << 8 | (int)(rgb.z * 255.0f);
    }

    public static int convertComponentsToARGB(Vector4f rgba) {
        return (int)(rgba.w() * 255.0f) << 24 | (int)(rgba.x() * 255.0f) << 16 | (int)(rgba.y() * 255.0f) << 8 | (int)(rgba.z() * 255.0f);
    }

    public static boolean lerp(Vector4f current, Vector4f target, float stepAmount) {
        if (target.distanceSquared((Vector4fc)current) > 1.0E-4f) {
            current.lerp((Vector4fc)target, stepAmount);
            return true;
        }
        return false;
    }

    public static int multiply(int color, float intensity) {
        Vector3f rgb = ColorUtils.convertRGBToComponents(color).mul(intensity, intensity, intensity);
        return ColorUtils.convertComponentsToRGB(rgb);
    }

    public static Vector3i toVec3i(Vector3f vector) {
        return new Vector3i((Vector3fc)vector, 0);
    }

    public static MapColor getMaterialColor(CustomColors color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case CustomColors.Blue -> MapColor.f_283743_;
            case CustomColors.Red -> MapColor.f_283913_;
            case CustomColors.Green -> MapColor.f_283784_;
            case CustomColors.Light -> MapColor.f_283919_;
            case CustomColors.Dark -> MapColor.f_283818_;
        };
    }
}

