/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widget;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.Rectangle;
import tv.soaryn.xycraft.core.ui.TiledIcon;
import tv.soaryn.xycraft.core.ui.widget.IWidget;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public class WindowWidget
implements IWidget.Background {
    private IWidget.Data _data = new IWidget.Data();
    private final TextureAtlas _textureAtlas;
    private final NineSlicedResource _window;
    private final TextureAtlasSprite _cloudFXSprite;
    private int _color;
    private final ResourceLocation HexResource;
    private int hexWidth = 256;
    private int hexHeight = 256;

    public WindowWidget(BaseMenuUI<?> ui, NineSlicedResource resource, float x, float y, float width, float height, int color) {
        this._data.Ui = ui;
        this._data.Dimensions = new Rectangle(x, y, resource.getMinWidth(width), resource.getMinHeight(height));
        this._window = resource;
        this._color = color;
        this._textureAtlas = (TextureAtlas)Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_);
        this._cloudFXSprite = this._textureAtlas.m_118316_(new ResourceLocation("xycraft_core", "block/cloudfx"));
        this.HexResource = new ResourceLocation("xycraft_core", "textures/gui/hex6.png");
        Optional hexResource = Minecraft.m_91087_().m_91098_().m_213713_(this.HexResource);
        if (hexResource.isEmpty()) {
            return;
        }
        try (NativeImage image = NativeImage.m_85058_((InputStream)((Resource)hexResource.get()).m_215507_());){
            this.hexWidth = image.m_84982_();
            this.hexHeight = image.m_85084_();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setColor(int color) {
        this._color = color;
    }

    public boolean lerpColor(int targetColor, float stepAmount) {
        int current = this.getColor();
        Vector4f targetVec = ColorUtils.convertRGBAToComponents(targetColor);
        Vector4f currentVec = ColorUtils.convertRGBAToComponents(current);
        if (ColorUtils.lerp(currentVec, targetVec, stepAmount)) {
            this.setColor(ColorUtils.convertComponentsToARGB(currentVec));
            return true;
        }
        return false;
    }

    public int getColor() {
        return this._color;
    }

    @Override
    @NotNull
    public IWidget.Data getData() {
        return this._data;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Vector4f rgba = ColorUtils.convertRGBAToComponents(this._color);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this._textureAtlas.m_118330_());
        RenderSystem.setShaderColor((float)rgba.x(), (float)rgba.y(), (float)rgba.z(), (float)rgba.w());
        poseStack.m_85836_();
        poseStack.m_252880_(4.0f, 4.0f, 0.0f);
        TiledIcon.render(poseStack, 0.0f, 0.0f, this._data.Dimensions.width() - 8.0f, this._data.Dimensions.height() - 8.0f, 1.0f, this._cloudFXSprite, new TiledIcon.TileConfiguration(false, this._data.Dimensions.width() - 8.0f, this._data.Dimensions.height() - 8.0f));
        float f = 0.25f;
        RenderSystem.setShaderColor((float)f, (float)f, (float)f, (float)0.85f);
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this.HexResource);
        float scale = 0.155f;
        TiledIcon.render(poseStack, 0.0f, 0.0f, this._data.Dimensions.width() - 8.0f, this._data.Dimensions.height() - 8.0f, scale, 0.0f, 1.0f, 0.0f, 1.0f, this.hexWidth, this.hexHeight, new TiledIcon.TileConfiguration(true, this._data.Dimensions.width() - 8.0f, this._data.Dimensions.height() - 8.0f));
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this._window.render(poseStack, 0.0f, 0.0f, (int)this._data.Dimensions.width(), (int)this._data.Dimensions.height(), 1.0f);
        poseStack.m_85849_();
    }
}

