/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.Rectangle;
import tv.soaryn.xycraft.core.ui.TiledIcon;
import tv.soaryn.xycraft.core.ui.widget.IWidget;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;

public class TankWidget
implements IWidget.Foreground {
    private final IWidget.Data _data;
    private final TextureAtlas _textureAtlas;
    private final NineSlicedResource _tankWindow;
    private final IFluidHandler _fluidHandler;
    private final int _tankIndex;

    public TankWidget(BaseMenuUI<?> ui, NineSlicedResource resource, @NotNull IFluidHandler fluidHandler, int tankIndex, float x, float y, float width, float height) {
        this._data = new IWidget.Data(ui);
        this._data.Dimensions = new Rectangle(x, y, resource.getMinWidth(width), resource.getMinHeight(height));
        this._tankIndex = tankIndex;
        this._textureAtlas = (TextureAtlas)Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_);
        this._tankWindow = resource;
        this._fluidHandler = fluidHandler;
    }

    @Override
    @NotNull
    public IWidget.Data getData() {
        return this._data;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        FluidStack fluid = this._fluidHandler.getFluidInTank(this._tankIndex);
        int capacity = this._fluidHandler.getTankCapacity(this._tankIndex);
        IClientFluidTypeExtensions fluidInfo = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        int color = fluidInfo.getTintColor(fluid);
        Vector4f rgb = ColorUtils.convertRGBAToComponents(color);
        TextureAtlasSprite sprite = fluid.isEmpty() ? null : this._textureAtlas.m_118316_(fluidInfo.getStillTexture(fluid));
        RenderSystem.enableBlend();
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this._textureAtlas.m_118330_());
        IWidget.Data data = this.getData();
        graphics.m_280509_(0, 0, (int)data.Dimensions.width(), (int)data.Dimensions.height(), -12369085);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(2.0f, 1.0f, 0.0f);
        if (!fluid.isEmpty()) {
            float fluidHeight = (float)fluid.getAmount() / (float)capacity;
            if (fluid.getFluid().m_205067_(Tags.Fluids.GASEOUS)) {
                rgb.w = Math.max((float)fluid.getAmount() / (float)capacity, 0.05f);
                if (rgb.w < 0.999f) {
                    RenderSystem.enableBlend();
                }
                fluidHeight = 1.0f;
            }
            fluidHeight = Math.max(fluidHeight, 0.05f);
            graphics.m_280246_(rgb.x(), rgb.y(), rgb.z(), rgb.w());
            if (sprite != null) {
                TiledIcon.render(poseStack, 0.0f, 0.0f, data.Dimensions.width(), fluidHeight * data.Dimensions.height() - 2.0f, 1.25f, sprite, new TiledIcon.TileConfiguration(false, data.Dimensions.width() - 2.0f, data.Dimensions.height() - 2.0f));
            }
        }
        poseStack.m_85849_();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("xycraft_core", "textures/gui/tank_markers.png"));
        RenderSystem.enableBlend();
        TiledIcon.innerBlit(poseStack.m_85850_().m_252922_(), 0.0f, data.Dimensions.width(), 0.0f, data.Dimensions.height(), 0.0f, 0.0f, 1.0f, 0.0f, data.Dimensions.height() / 16.0f);
        this._tankWindow.render(poseStack, 0.0f, 0.0f, data.Dimensions.width(), data.Dimensions.height(), 1.0f);
    }

    @Override
    public void onToolTip(double mouseX, double mouseY, List<Component> tooltip) {
        FluidStack fluid = this._fluidHandler.getFluidInTank(this._tankIndex);
        DecimalFormat format = new DecimalFormat(",##0.###");
        boolean showAdded = Screen.m_96638_() || ModifierKeyCapability.of(Utils.getClientPlayer());
        MutableComponent component = Component.m_237119_();
        if (!fluid.isEmpty()) {
            component.m_7220_((Component)Component.m_237115_((String)fluid.getTranslationKey()).m_130946_(": ").m_130948_(Style.f_131099_.m_178520_(0xFFCC11)));
            int amount = fluid.getAmount();
            if (amount >= 1000 && !showAdded) {
                component.m_7220_((Component)Component.m_237113_((String)String.format("%s B", format.format((double)amount / 1000.0))).m_130940_(ChatFormatting.WHITE));
            } else {
                component.m_7220_((Component)Component.m_237113_((String)String.format("%s mB", format.format(amount))).m_130940_(ChatFormatting.WHITE));
            }
        } else {
            component.m_7220_((Component)Component.m_237115_((String)"gui.xycraft_machines.tank.empty"));
        }
        tooltip.add((Component)component);
        int capacity = this._fluidHandler.getTankCapacity(this._tankIndex);
        MutableComponent capacityComponent = Component.m_237115_((String)"gui.xycraft_machines.tank.capacity").m_130946_(": ").m_130948_(Style.f_131099_.m_178520_(0x77BBFF));
        if (capacity >= 1000 && !showAdded) {
            capacityComponent.m_7220_((Component)Component.m_237113_((String)String.format("%s B", format.format((double)capacity / 1000.0))).m_130940_(ChatFormatting.WHITE));
        } else {
            capacityComponent.m_7220_((Component)Component.m_237113_((String)String.format("%s mB", format.format(capacity))).m_130940_(ChatFormatting.WHITE));
        }
        tooltip.add((Component)capacityComponent);
        IWidget.Foreground.super.onToolTip(mouseX, mouseY, tooltip);
    }
}

